/*
 * Decompiled with CFR 0.152.
 */
package com.servprise.webreboot;

import com.servprise.webreboot.Command;
import com.servprise.webreboot.WebRebootException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class WebRebootConnection {
    static final String ENCODING = "UTF-8";
    static final BigDecimal WEBREBOOT_3_0_VERSION = new BigDecimal("3.0");
    static final BigDecimal WEBREBOOT_3_1_VERSION = new BigDecimal("3.1");
    private final String sessionID;
    private final String baseUrl;
    private final Map parameters = new HashMap();
    protected String cookies = null;

    public WebRebootConnection(String string, String string2, String string3) {
        this.baseUrl = string3 + "://" + string + ":" + string2 + "/";
        String string4 = String.valueOf(new Random().nextLong());
        while (string4.length() < 12) {
            string4 = string4 + "0";
        }
        this.sessionID = string4.substring(0, 12);
        this.loadParameters();
    }

    String getSession() {
        return this.sessionID;
    }

    String getCodeBase() {
        return this.baseUrl;
    }

    private void setParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    String getParameter(String string) {
        return (String)this.parameters.get(string);
    }

    String getVersion() {
        if (this.parameters.containsKey("version")) {
            return this.getParameter("version");
        }
        return "2.0";
    }

    final void loadParameters() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            URL uRL = new URL(this.getCodeBase() + "params.htm");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Connection", "close");
            if (null != this.cookies) {
                httpURLConnection.setRequestProperty("Cookie", this.cookies);
            }
            httpURLConnection.setDoOutput(false);
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), ENCODING));
            String string2 = httpURLConnection.getHeaderField("Set-Cookie");
            if (null != string2) {
                this.cookies = string2;
            }
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("><PARAM");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.startsWith("<PARAM")) continue;
                    int n = stringArray[i].indexOf(34);
                    int n2 = stringArray[i].indexOf(34, n + 1);
                    int n3 = stringArray[i].indexOf(34, n2 + 1);
                    int n4 = stringArray[i].lastIndexOf(34);
                    String string3 = stringArray[i].substring(n + 1, n2);
                    String string4 = stringArray[i].substring(n3 + 1, n4);
                    this.setParameter(string3, string4.replaceAll("&gt;", ">"));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebRebootException("Could not connect to WebReboot.", malformedURLException);
        }
        catch (IOException iOException) {
            throw new WebRebootException("Network problem encountered communicating with WebReboot.", iOException);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new WebRebootException("Problem closing connection to WebReboot.", iOException);
                }
            }
        }
    }

    protected void sendCommand(Command command, boolean bl) {
        try {
            URL uRL = new URL(this.getCodeBase() + command.command);
            final HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Connection", "close");
            if (null != this.cookies) {
                httpURLConnection.setRequestProperty("Cookie", this.cookies);
            }
            httpURLConnection.setDoOutput(false);
            httpURLConnection.setUseCaches(false);
            String string = httpURLConnection.getHeaderField("Set-Cookie");
            if (string != null) {
                this.cookies = string;
            }
            if (!bl) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            httpURLConnection.getResponseCode();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }).start();
                return;
            }
            httpURLConnection.getResponseCode();
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebRebootException("Could not connect to WebReboot.", malformedURLException);
        }
        catch (IOException iOException) {
            throw new WebRebootException("Network problem encountered communicating with WebReboot.", iOException);
        }
    }

    int getUserSlot() {
        return Integer.valueOf(this.getParameter("userslot"));
    }

    boolean isLoggedIn() {
        this.loadParameters();
        String string = this.getParameter("usercheck");
        String string2 = this.getSession();
        return string2.substring(0, 4).equals(string) && this.getParameter("loggedin").equals("1");
    }

    boolean isInUse() {
        this.loadParameters();
        return !this.getParameter("usercheck").equals("    ");
    }

    static String normalizeText(String string, int n) {
        try {
            string = string.replaceAll(">", "&gt;");
            byte[] byArray = string.getBytes(ENCODING);
            if (byArray.length > n) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                string = new String(byArray2);
            }
            while (string.getBytes(ENCODING).length < n) {
                string = string + " ";
            }
            string = URLEncoder.encode(string, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WebRebootException("System does not support UTF-8 encoding.", unsupportedEncodingException);
        }
        return string;
    }

    static String generateHexStringRepresentation(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            String string = Integer.toHexString(nArray[i] & 0xFF);
            if (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append("%").append(string);
        }
        return stringBuffer.toString();
    }
}

