#!/usr/bin/perl -w
################################################################################################################################
##
## Nagios Agent for WebSphere Application Server
## Ruben Dario Garcia Alonso
## 2011/01/24   Version  .9   JVM, sessions, threads
## 2011/03/15   Version 1.1  include monitoring live transations, garbage collectio values, help module
## 2011/03/24   Version 1.2  include parameters and  network deployment support
## 20011/06/09  Version 1.3  include  authentication fix by Michele Buccarello
##
################################################################################################################################

use LWP::Simple;
use XML::Simple;
use Data::Dumper;
use Getopt::Long;
use warnings;



my ($msg,$type,$warning,$subtype,$critical,$server,$port,$nodename,$servername,$warapp,$servlet,$myear,$jdbcname,$dataname,$war);
my $wasuser = "wpsadmin";
my $waspassword = "password";

GetOptions ("type=s" => \$type,    		   # main type
			"subtype:s" => \$subtype, 	   # subtype
			"warning=i" => \$warning, 	   # subtype
			"critical=i" => \$critical, 	   # subtype
			"server=s" => \$server, 	   # server
			"port=s" => \$port, 		   # port
			"nodename:s" => \$nodename, 	   # nodename
	        "servername:s" => \$servername,    # servername
			"warapp:s" => sub{$warapp=""},	   # war applicaction
			"servlet:s" => \$servlet, 	   # servlet
			"earname:s" => sub{$myear=""}, 	   # ear name
			"jdbc:s" => \$jdbcname, 	   # servlet
			"datasource:s" => \$dataname,	   # servlet
			"user:s" => \$wasuser,
			"pass:s" => \$waspassword
			);
					   
#if ( @ARGV == 0 )
#{
#  print "usage: cwas-nagios.pl {type} {warning value} {critical value} {subtype} {nodename} {servername} --port {port} {ip addres} {optional1} {optional2} \nfor help use cwas-nagios.pl help {type}\n";
#  $type=" ";

#}

sub getwasperf {
    my $url = shift;
    my $suffix = int(rand(1000)*rand(100));
    my $value = qx(wget -qO- --user=$wasuser --password=$waspassword $url); 
    my $xml = new XML::Simple;
    my $data = $xml->XMLin($value);
    return $data;
}



################################################################################################################################
##
## Funcion de monitoreo de jvm de  websphere, incluye uso de jvm y de cpu
##
################################################################################################################################
sub checkjvm {
	
        my $xmldata="";
        if(defined($servername) && defined($nodename)){
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?node=$nodename&server=$servername&Module=jvmRuntimeModule");
        }
        else {
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?Module=jvmRuntimeModule");
        }


        if ($subtype eq 'mem'){   
                my $jvmused =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'CountStatistic'}->{'UsedMemory'}->{'count'} );
                my $jvmmax =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'BoundedRangeStatistic'}->{'upperBound'} );
                my $values = int(($jvmused / $jvmmax) *100);
                if ( $values >  $critical ) {
                          $msg= "CRITICAL - JVM = $values; | JVM = $values;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($values > $warning) {
                        $msg= "WARNING - JVM = $values; | JVM = $values;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - JVM = $values; | JVM = $values;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        elsif ($subtype eq 'cpu'){
                my $cpuused =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'CountStatistic'}->{'ProcessCpuUsage'}->{'count'} ); 
                if ( $cpuused >  $critical ) {
                          $msg= "CRITICAL - CPU = $cpuused; | JVM = $cpuused;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($cpuused > $warning) {
                        $msg= "WARNING - CPU = $cpuused; | JVM = $cpuused;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - CPU = $cpuused; | JVM = $cpuused;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        elsif ($subtype eq 'gcinterval'){
                my $gccount =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{'Garbage Collection'}->{'CountStatistic'}->{'count'} );
                my $gcinterval =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{'Garbage Collection'}->{'TimeStatistic'}->{'GCIntervalTime'}->{'totalTime'} );
                my $gctinterval = sprintf("%d",$gcinterval / $gccount);
                if ( $gctinterval >  $critical ) {
                          $msg= "CRITICAL - Garbage Collection Interval = $gctinterval milliseconds  response time; | Garbage Collection Interval = $gctinterval;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($gctinterval > $warning) {
                        $msg= "WARNING - Garbage Collection Interval = $gctinterval milliseconds response time; | Garbage Collection Interval = $gctinterval;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Garbage Collection Interval = $gctinterval milliseconds response time  ;| Garbage Collection Interval = $gctinterval;$warning;$critical;;";
                        $exit_code=0;
                }    
        }
        elsif ($subtype eq 'gctime'){
                my $gccount =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{'Garbage Collection'}->{'CountStatistic'}->{'count'} );
                my $gctime =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{'Garbage Collection'}->{'TimeStatistic'}->{'GCTime'}->{'totalTime'} );
                my $gcttime = sprintf("%d",$gctime / $gccount);
                if ( $gcttime >  $critical ) {
                          $msg= "CRITICAL - Garbage Collection Time = $gcttime; | Garbage Collection Time = $gcttime;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($gcttime > $warning) {
                        $msg= "WARNING - Garbage Collection Time = $gcttime; | Garbage Collection Time = $gcttime;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Garbage Collection Time = $gcttime; | Garbage Collection Time = $gcttime;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        return $msg,$exit_code;
}
###############################################################################################################################
##
## Help function
##
################################################################################################################################
sub helpcwas{
	my $type = shift;
        if(defined($type)) {
	if($type eq 'jvm'){
		print "Usage for monitoring jvm values:\n\tFor average of memory: cwas-nagios.pl --type jvm --warning {warning value} --critical {critical value} --subtype mem --port {port} --server {ip addres}\n\tFor cpu usage: cwas-nagios.pl -type jvm --warning {warning value} --critical {critical value} --subtype cpu --port  {port} --server {ip addres}\n";
	}
	elsif($type eq 'sessions'){
		print "Usage for monitoring number of sessions for war application:\n\tFor sessions alive in application: cwas-nagios.pl --type sessions --warning {warning value} --critical {critical value} --earname {ear application} --port {port} --server {ip addres}\n";
	}
	elsif($type eq 'threads'){
		print "Usage for monitoring threads values:\n\tFor websphere thread numbers: cwas-nagios.pl --typet hreads --warning {warning value} --critical {critical value} --subtype num --port {port} --server {ip addres}\n\tFor websphere hangs thread numbers: cwas-nagios.pl --type threads --warning {warning value} --critical {critical value} --subtype hangs --port {port} {ip addres}\n";
	}
	elsif($type eq 'jdbc'){
		print "Usage for monitoring connections values:\n\t";
	}
	elsif($type eq 'trans'){
		print "Usage for websphere transactions:\n\tFor websphere transaction number: cwas-nagios.pl --type trans --warning {warning value} --critical {critical value}  --port {port} --server {ip addres}\n";
	}
	elsif($type eq 'servlet'){
		print "Usage for monitoring servlet request time:\n\tFor war application request  time: cwas-nagios.pl --type servlet --warning {warning value} --critical {critical value} --subtype webapp --port {port} --server {ip addres} --warapp {war application}\n\tFor particular jsp request time: cwas-nagios.pl --type servlet --warning {warning value} --critical {critical value} -subtype servet --port {port} --server {ip addres} --warapp {war application} --servlet {jsp name}\n";
		}
	}
	else{
	  print "use --type help jvm or help sessions or help threads or help jdbc or help trans or help servlet for more detailed informations\n";
	}
}


################################################################################################################################
##
## Funcion de monitoreo de sesiones de  websphere por contenedor de servlet
##
################################################################################################################################
sub checksessions{
        my $xmldata="";
	if(defined($servername) && defined($nodename)){
		$xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?node=$nodename&server=$servername&Module=servletSessionsModule");
        }
        else {
        	$xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?Module=servletSessionsModule");
	}
        
	my $sesions =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$myear}->{'RangeStatistic'}->{'LiveCount'}->{'value'} );              
        if ( $sesions >  $critical ) {
                  $msg= "CRITICAL - Sessions = $sesions; | Sessions = $sesions;$warning;$critical;;";
                  $exit_code=2;
        }
        elsif ($sesions > $warning) {
                $msg= "WARNING - Sessions = $sesions; | Sessions = $sesions;$warning;$critical;;";
                $exit_code=1;
        }
        else {
                $msg= "OK - Sessions = $sesions; | Sessions = $sesions;$warning;$critical;;";
                $exit_code=0;
        }
        return $msg,$exit_code;
}

################################################################################################################################
##
## Funcion de monitoreo de live transacctions de  websphere
##
################################################################################################################################
sub checktrans{

        my $xmldata=""; 
        if(defined($servername) && defined($nodename)){
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?node=$nodename&server=$servername&Module=transactionModule");
        }
        else {
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?Module=transactionModule");
        }

        my $trans =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'CountStatistic'}->{'ActiveCount'}->{'count'} );
        if ( $trans >  $critical ) {
                  $msg= "CRITICAL - Transaction = $trans; | Transaction = $trans;$warning;$critical;;";
                  $exit_code=2;
        }
        elsif ($trans > $warning) {
                $msg= "WARNING - Transaction = $trans; | Transaction = $trans;$warning;$critical;;";
                $exit_code=1;
        }
        else {
                $msg= "OK - Transaction = $trans; | Transaction = $trans;$warning;$critical;;";
                $exit_code=0;
        }
        return $msg,$exit_code;
}


################################################################################################################################
##
## Funcion de monitoreo de threads de  websphere, incluye  numero  total de treadh y de threads en estado hang
##
################################################################################################################################

sub checkthreads {

 my $xmldata="";
        if(defined($servername) && defined($nodename)){
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?node=$nodename&server=$servername&Module=threadPoolModule");
        }
        else {
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?Module=threadPoolModule");
        }

        if ($subtype eq 'num'){
                my $numthreads =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{'WebContainer'}->{'BoundedRangeStatistic'}->{'value'} );
                if ( $numthreads >  $critical ) {
                          $msg= "CRITICAL - Threads = $numthreads; | Threads = $numthreads;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($numthreads > $warning) {
                        $msg= "WARNING - Threads = $numthreads; | Threads = $numthreads;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Threads = $numthreads; | Threads = $numthreads;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        elsif ($subtype eq 'hangs') {
                my $numhangs =  sprintf("%d", $xmldata-> {'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{'WebContainer'}->{'RangeStatistic'}->{'value'} );
                if ( $numhangs >  $critical ) {
                          $msg= "CRITICAL - Hangs = $numhangs; | Hangs = $numhangs;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($numhangs > $warning) {
                        $msg= "WARNING - Hangs = $numhangs; | Hangs = $numhangs;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Hangs = $numhangs; | Hangs = $numhangs;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        return $msg,$exit_code;
}
 

################################################################################################################################
##
## Funcion de monitoreo de jdbcs de  websphere, incluye funciones de  numero de pools por datasource,  
#  wait y used time por  datasource
##
################################################################################################################################

sub checkjdbc {

 my $xmldata="";
        if(defined($servername) && defined($nodename)){
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?node=$nodename&server=$servername&Module=connectionPoolModule");
        }
        else {
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?Module=connectionPoolModule");
        }


        if ($subtype eq 'conections'){
                my $numcons =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$jdbcname}->{'Stat'}->{$dataname}->{'BoundedRangeStatistic'}->{'PoolSize'}->{'value'} );
                if ( $numcons >  $critical ) {
                          $msg= "CRITICAL - Conections = $numcons; | Conections = $numcons;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($numcons > $warning) {
                        $msg= "WARNING - Conections = $numcons; | Conections = $numcons;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Conections = $numcons; | Conections = $numcons;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        elsif ($subtype eq 'waitt') {
                my $waittime =  sprintf("%d", $xmldata-> {'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$jdbcname}->{'Stat'}->{$dataname}->{'TimeStatistic'}->{'WaitTime'}->{'totalTime'});
                if ( $waittime >  $critical ) {
                          $msg= "CRITICAL - Wait_time = $waittime; | Wait_time = $waittime;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($waittime > $warning) {
                        $msg= "WARNING - Wait_time = $waittime; | Wait_time = $waittime;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Wait_time = $waittime; | Wait_time = $waittime;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        elsif ($subtype eq 'used') {
                my $usetime =  sprintf("%d", $xmldata-> {'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$jdbcname}->{'Stat'}->{$dataname}->{'TimeStatistic'}->{'UseTime'}->{'totalTime'});
                if ( $usetime >  $critical ) {
                          $msg= "CRITICAL - Used_time = $usetime; | Used_time = $usetime;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($usetime > $warning) {
                        $msg= "WARNING - Used_time = $usetime; | Used_time = $usetime;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Used_time = $usetime; | Used_time = $usetime;$warning;$critical;;";
                        $exit_code=0;
                }
        }     
        return $msg,$exit_code;
}

################################################################################################################################
##
## Funcion de monitoreo de servlets
##
################################################################################################################################

sub checkservlets {


        my $xmldata= "";

        if(defined($servername) && defined($nodename)){
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?node=$nodename&server=$servername&Module=webAppModule");
        }
        else {
                $xmldata=getwasperf("http://$server:$port/wasPerfTool/servlet/perfservlet?Module=webAppModule");
        }


	if ($subtype eq 'warapp'){
                my $countservlet =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$warapp}->{'Stat'}->{'CountStatistic'}->{'RequestCount'}->{'count'} );
                my $timeservlet =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$warapp}->{'Stat'}->{'TimeStatistic'}->{'ServiceTime'}->{'totalTime'} );
                my $servicetime= sprintf("%d", $timeservlet/$countservlet);
                if ( $servicetime >  $critical ) {
                          $msg= "CRITICAL - Service Time = $servicetime; | Service Time = $servicetime;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($servicetime > $warning) {
                        $msg= "WARNING - Service Time = $servicetime; | Service Time = $servicetime;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Service Time = $servicetime; | Service Time = $servicetime;$warning;$critical;;";
                        $exit_code=0;
                }
        }
        elsif ($subtype eq 'servlet') {
                my $countservlet =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$warapp}->{'Stat'}->{'Stat'}->{$servlet}->{'Stat'}->{'Stat'}->{'CountStatistic'}->{'count'} );
                my $timeservlet =  sprintf("%d", $xmldata->{'Node'}->{'Server'}->{'Stat'}->{'Stat'}->{$warapp}->{'Stat'}->{'Stat'}->{$servlet}->{'Stat'}->{'Stat'}->{'TimeStatistic'}->{'totalTime'} );
                my $servicetime= sprintf("%d",$timeservlet/$countservlet);
                if ( $servicetime >  $critical ) {
                          $msg= "CRITICAL - Servlet Time = $servicetime; |  Servlet Time = $servicetime;$warning;$critical;;";
                          $exit_code=2;
                }
                elsif ($servicetime > $warning) {
                        $msg= "WARNING - Servlet Time = $servicetime; |  Servlet Time = $servicetime;$warning;$critical;;";
                        $exit_code=1;
                }
                else {
                        $msg= "OK - Servlet Time = $servicetime; |  Servlet Time = $servicetime;$warning;$critical;;";
                        $exit_code=0;
                }
        }
	return $msg,$exit_code;
}

 
################################################################################################################################
##
## comando check_was
##
################################################################################################################################

if ($type eq 'jvm') {
        my ($mensaje,$exit_code) = checkjvm();
        print "$mensaje\n";
        exit $exit_code;
}
elsif ($type eq 'sessions') {
        my ($mensaje,$exit_code)=checksessions();
        print "$mensaje\n";
        exit $exit_code;
}
elsif ($type eq 'threads') {
        my ($mensaje,$exit_code)=checkthreads();
        print "$mensaje\n";
        exit $exit_code;
}
elsif ($type eq 'jdbc') {
        my ($mensaje,$exit_code)=checkjdbc();
        print "$mensaje\n";  
        exit $exit_code;
}
elsif ($type eq 'trans') {
        my ($mensaje,$exit_code)=checktrans();
        print "$mensaje\n";
        exit $exit_code;
}
elsif ($type eq 'servlet') {
        my ($mensaje,$exit_code)=checkservlets();
        print "$mensaje\n";
        exit $exit_code;
}
elsif ($type eq 'help') {
        helpcwas($ARGV[0]);
        exit;
}
else {
        exit 3;
}

