#!/usr/bin/perl

###################################################################################################
#												  #
#   NAGIOS PlugIn for Zyxel G570S Access Points (Other similar models may work)                   #
#   Author: Jorge Rocafort (jrocafortcimadevila@hotmail.com)					  #
#   Version 0.1											  #
#   Features: Get the connected stations and show them in the NAGIOS GUI			  #
#												  #
###################################################################################################

use lib "/usr/local/nagios/libexec";
use utils qw($TIMEOUT %ERRORS);

use strict;

use MIME::Base64;
use HTTP::Lite;
use Getopt::Long;

Getopt::Long::Configure('bundling');

# Comprobar que estan todos los parametros
if (scalar(@ARGV)<1) {
	print "check_g750s <ip[:port]>.\n";
	exit($ERRORS{'UNKNOWN'});
}

my $condition = $ERRORS{'OK'};

my $ip=$ARGV[0];

my $http=new HTTP::Lite;

#my $encoded = encode_base64("$login:$password");
	
#Obtener el HTML del punto de acceso

my $req=$http->request("http://$ip/association_list.html");

if ($req ne "200") {
$condition=$ERRORS{'CRITICAL'};
exit ($condition);
}
else {
my $body=$http->body();

my @estado=("Authenticating","Associated","Reassociating","Deaunthenticated","Deassociated");
#Procesar el resultado obtenido

#Los datos que necesitamos vienen dentro de funciones JavaScript, en variables

#Flags:
my $flagips=0;
my $flagstatus=0;
my $flagmacs=0;
my $flagsinal=0;

#Step 0: Convertir el HTML en un array de lineas
my @lineas=split /\n/, $body;

my $ips;
my $status;
my $macs;
my $sinal;

#Step 1: Buscar la funcion JavaScript donde tenemos los datos y obtenerlos
my $linea;
foreach $linea(@lineas) {
	if (index($linea,"var ips")>=0) {
		$ips=$linea;
		$flagips=1;
	}
	if (index($linea,"var stastatus")>=0) {
		$status=$linea;
		$flagstatus=1;
	}
	if (index($linea,"var maclist")>=0) {
		$macs=$linea;
		$flagmacs=1;
	}
	if (index($linea,"var ap_rssi")>=0) {
		$sinal=$linea;
		$flagsinal=1;
	}
	if (($flagips) && ($flagstatus) && ($flagmacs) && ($flagsinal)) {
		last;
	}
}

#Step 2: Procesar los datos

my @linea1=split /\"/, $ips;
my @ips=split /\|/, $linea1[1];

my @linea2=split /\"/, $status;
my @status=split /\|/, $linea2[1];

my @linea3=split /\"/, $macs;
my @macs=split /\|/, $linea3[1];

my @linea4=split /\"/, $sinal;
my @sinal=split /\|/, $linea4[1];

my $stations=@macs;
if ($stations<=0) {
	print "[OK]Not connected stations to this access point";
}
else {
	print "[OK]" . $stations . " stations connected to this access point";
}
print "\n";
my $contador=-1;
foreach $ip(@ips) {
	print $macs[$contador];
	$contador++;
	print "    ";
	print $ip;
	print "    ";
	print $estado[$status[$contador]];
	print "    ";	
	print $sinal[$contador];
	print "\n";
}


}


exit($condition);

