#!/bin/bash
#set -x
##########################################################################################################################
#                                                                                                                        #
#       Author          :       Gourav Joshi                                                                             #
#       Date            :       16 June 2011                                                                             #
#	Email		:	gouravjoshi@gmail.com									 #
#       Objective       :       NRPE plugin support file to get output of postfix queue.                                 #
#       Usage           :       Put this file into libexec directory of Nagios installation                              #
#                               and configure its output file name to be used in queuemon file. 			 #
#				Example :-							                         #
#                       /bin/bash /usr/local/nagios/libexec/check_postque.sh -w 500000 -c 700000 -p postfix > /tmp/queue #  
#                               where /tmp/queue is the output file name of quemon script.                               #
#                               -w Warning limit(KB), -c Critical limit (KB), -p Postfix instance name                   #   #       			     The above example will check postfix with warning limit 500MB and Critical limit 700MB   #
#												                         #
##########################################################################################################################


STATE_OK=0
STATE_WARNING=1
STATE_CRITICAL=2
STATE_UNKNOWN=3



if [ "$#" == "6" ]

then

#Set variables
arg=$6
w=$2
c=$4
mt="Mail queue is empty"



 
emp=`postqueue -c /etc/$arg -p`

if [ "$emp" = "$mt" ]; then

echo "OK : $mt"
exitstatus=$STATE_OK
else

crt=`postqueue -c /etc/$arg -p | grep Kbytes | sed -e 's/^.*--.//g' | awk '{print $1}'`
mg=`postqueue -c /etc/$arg -p | grep Kbytes | sed -e 's/^.*--.//g' | awk '{print $4}'`

if [ $crt -gt $c ]

then 

echo "Critical : Queue has $mg messages in $crt Kbytes, higher then critical limit $c"

exitstatus=$STATE_CRITICAL

elif

 [ $crt -gt $w ]

then

echo "Warning : Queue has $mg messages in $crt Kbytes, higher then warning limit $w"

exitstatus=$STATE_WARNING

else

echo "OK : Mail queue has $mg messages in $crt Kbytes."

exitstatus=$STATE_OK
fi

fi

else
echo " "
echo "Please provide parameters to work with."
echo "Help : ./postfixqueue.sh -w 20 -c 30 -p postfix"
echo "Where :"
echo "       -w = Warning limit"
echo "       -c = Critical limit"
echo "       -p = Postfix instance name"
echo " "




fi
exit $exitstatus
