#!/bin/bash

#
# Checks if important nodes are associated with a schedule
#
# 2006 Volker Maibaum volker.maibaum@web.de
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

noassoc_data=`dsmadmc $TSM_SERVER_STANZA -comma -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes "select node_name from nodes where node_name not in (select distinct node_name from associations)"` 

noassoc=`echo $noassoc_data | xargs -n1 echo | egrep -i "$tsm_assoc_nodes" | xargs echo` 


if [ $? -ne 0 ]
then
	echo "Return code of dsmadmc query is not 0!"
	exit 3
fi

if [ -z "$noassoc" ]
then
	echo "OK: All important servers associated with a schedule"
	exit 0
else
	echo "CRIT: Important server(s) NOT associated with schedule ($noassoc)"
	exit 2
fi
