#!/bin/bash

#
# shows mb that where backed up in the last 24 hours
# for statistical purpose
#
. ${TSM_CHECKS_ENV:-./tsm_checks.env}

warn=1250

sum=`dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "select sum(cast(bytes/1024/1024/1024 as decimal(8,2))) as SUM from summary where start_time>=current_timestamp - 1 day and activity='BACKUP'" | grep -v "^AN[R,S]" | sed "s/ //g" | sed "s/,/./g"` 

sum2=`echo $sum|sed "s/\..*//"`
sum2=$((sum2+0))

rc=0
if [ "$sum2" -eq "0" ]
then
	sum="0"
fi

if [ "$sum2" -gt "$warn" ]
then 
	msg="Warning: $sum GB Backed up|backup_gb=$sum;0;0;0;0" 
	rc=1
else
	msg="$sum GB Backed up|backup_gb=$sum;0;0;0;0" 
	rc=0

fi

echo $msg
exit $rc
