#!/bin/bash

#
# Monitors database utilization
# also performance data for cachehit ratio
#
# 2006- Allen S. Rout asr@ufl.edu
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}


read hrs <<EOQ 
$(\
dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes \
"select (timestamp(current_date,current_time)-last_backup_date) hours from  db" \
)
EOQ


# Reassigning these mostly to make the following substitution line less wordy.

w=$tsm_db_backuptime_w
c=$tsm_db_backuptime_c

perf="$hrs hours since last DB backup ($TSM_SERVER) | backup_age=;$hrs;$w;$c;0;0"

if  [[ $(( $hrs > $c )) == 1 ]] ; then
    echo "CTRITICAL $perf"
    exit 2;
elif [[ $(( $hrs > $w )) == 1 ]] ; then 
    echo "WARNING $perf"
    exit 1;
else
    echo "OK $perf"
    exit 0;
fi

echo " SERIOUS ERROR! Should not be reachable.."

exit 3;
