#!/bin/bash

#
# Monitors database utilization
# also performance data for cachehit ratio
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

w=$tsm_db_util_w
c=$tsm_db_util_c
dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT PCT_UTILIZED, MAX_PCT_UTILIZED, CACHE_HIT_PCT FROM DB" | grep -v "^AN[R,S]" | sed "s/,/./g" | awk -v c=$c -v w=$w ' 
{
	pctutil=$1;
	maxutil=$2;
	cachehit=$3;
	mesg="";
	perf=sprintf(" | pctutil=%s;%s;%s;0;100 maxutil=%s;%s;%s;0;100 cachehit=%s;;0;100;",pctutil,w,c,maxutil,w,c,cachehit);
	if ( maxutil > c ){
		print "CRITICAL DB maxpcutil > " c " %" perf;		
		exit 2;
	}else if ( maxutil > w){
		print "WARNING DB maxpcutil > " w " %" perf;		
		exit 1;
	}else{
		print "OK DB maxpcutil < " w " %" perf;		
		exit 0;
	}
	print "something is wrong in testscript"
	exit 3;

}'
