#!/bin/bash

#
# Get the drive states (IN USE | IDLE | DISMOUNTING | WAITING FOR VOL)
# The check is not used to raise any alarms.
# I use it for graphing the states with rrd. So I see how many drives 
# where available at a given time.
#
. ${TSM_CHECKS_ENV:-./tsm_checks.env}
dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "q mount" | grep "status:" | grep -v "FILE" | sed "s/^.*status: //" | sed "s/\.//g" | awk '
BEGIN{
	in_use=0
	idle=0
	dismounting=0
	waiting=0
	empty=4
}
{
	if ( $0 == "IN USE" ){
		in_use=in_use+1;	
		empty=empty-1;
	}
	if ( $0 == "IDLE" ){
		idle=idle+1;	
		empty=empty-1;
	}
	if ( $0 == "DISMOUNTING" ){
		dismounting=dismounting+1;	
		empty=empty-1;
	}
	if ( $0 == "WAITING FOR VOLUME" ){
		waiting=waiting+1;	
		empty=empty-1;
	}
	if ( empty < 0 ){
		empty=0;
		if ( waiting > 0 ){
			waiting=waiting-1;
		}else{
			if (dismounting > 0){
				dismounting=dismounting-1
			}
		}
	}
}
END{
	perf=sprintf("empty=%s;;;; in_use=%s;;;; idle=%s;;;; dismounting=%s;;;; waiting=%s;;;;", empty, in_use,idle,dismounting,waiting)  
	print "drive state info OK | " perf
	exit 0;
}'
