#!/bin/bash

#
# 2006 Volker Maibaum volker.maibaum@web.de
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

read nr <<EOQ 
$(\
dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes \
"select count(*) from drives where online='YES'" \
)
EOQ

# Reassigning these mostly to make the following substitution line less wordy.

w=$tsm_drives_w
c=$tsm_drives_c

perf="Online Drives: $nr ($TSM_SERVER) | drives=$nr;$w;$c;0;0"

if  [ $nr -gt $w ] ; then
    echo "OK $perf"
    exit 0;
elif  [ $nr -gt $c ] ; then
    echo "WARNING $perf"
    exit 1;
else
    echo "CRIT $perf"
    exit 2;
fi

echo " SERIOUS ERROR! Should not be reachable.."
exit 3;
