#!/bin/bash

#
# Monitors tapes with errors
#
# 2006 Volker Maibaum volker.maibaum@web.de
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

errors=`dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes "SELECT volume_name,access, ';' FROM volumes a, devclasses b WHERE (a.devclass_name = b.devclass_name) AND (b.devtype<> 'FILE' AND b.access_strategy='Sequential') AND error_state<>'NO'"`
if [ "$?" -eq "11" ]
then
	echo "OK: no tapes with errors";
	exit 0;
fi



	echo "CRITICAL: Tapes in error state: `echo $errors | xargs echo`";
	exit 2;

echo "UNKNOWN: Error in script - this should not happen ";
exit 3;
