#!/bin/bash

#
# Monitors number of free scratch tapes
#
. ${TSM_CHECKS_ENV:-./tsm_checks.env}

# waring
w=8
# critical
c=3

dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT count(*) FROM libvolumes WHERE STATUS='Scratch'" | grep -v "^AN[R,S]" | awk -v c=$c -v w=$w '
{
	nr=$1;
	mesg="";
	perf=sprintf(" | free_tapes=%s;%s;%s;0;0",nr,w,c); 
	if ( nr < c ){
		print "CRITICAL Free Scratch Tapes = " nr " < " c perf;
		exit 2;
	}else if ( nr < w){
		print "WARNING Free Scratch Tapes = " nr " < " w  perf;
		exit 1;
	}else{
		print "OK Free Scratch Tapes = " nr " > " w  perf;		
		exit 0;
	}
	print "something is wrong in testscript"
	exit 3;

}'
