#!/bin/bash

#
# Monitors database utilization
# also performance data for cachehit ratio
#
# 2006- Allen S. Rout asr@ufl.edu
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}


read nr <<EOQ 
$(\
dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes \
"select count(*) from volhistory where date_time>=current_timestamp-$tsm_fulldb_hours hours AND type='BACKUPFULL'"\
)
EOQ

#
# Check if we are out of time period (no full db backups on weekends, only snapshots to disk)
# don't check saturday and sunday and monday before 10:00 o'clock 

weekend=0
day_of_week=`date +"%u"`
hours=`date +"%k"`
if [ $day_of_week -eq 6 ] || [ $day_of_week -eq 7 ]
then 
	weekend=1
elif [ $day_of_week -eq 1 ] && [ $hours -lt 10 ]
then
	weekend=1
fi
if [ $weekend -eq 1 ]
then
	echo "OK: no full db backups on weekends, only snapshots to disk"
	exit 0;
fi

perf="$nr Full DB backups in last $tsm_fulldb_hours hours ($TSM_SERVER) | backup_age=;$nr;;;;"

if  [ "$nr" -ge "1" ] ; then
    echo "OK: $perf"
    exit 0;
else   
    echo "CRITICAL: $perf"
    exit 2;
fi

echo " SERIOUS ERROR! Should not be reachable.."

exit 3;
