#!/bin/bash

#
# Monitors log utilization
#
. ${TSM_CHECKS_ENV:-./tsm_checks.env}

# warning
w=90
# critical
c=95

dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT PCT_UTILIZED, MAX_PCT_UTILIZED FROM LOG" | grep -v "^AN[R,S]" | awk -v c=$c -v w=$w '
{
	pctutil=$1;
	maxutil=$2;
	cachehit=$3;
	mesg="";
	perf=sprintf(" | pctutil=%s;%s;%s;0;100 maxutil=%s;%s;%s;0;100",pctutil,w,c,maxutil,w,c);
	if ( maxutil > c ){
		print "CRITICAL LOGSPACE max utilized: "maxutil"% > " c "%, currently utilized = "pctutil "% " perf;		
		exit 2;
	}else if ( maxutil > w){
		print "WARNING LOGSPACE max utilized: "maxutil"% > " w "%, currently utilized = "pctutil "% "  perf;		
		exit 1;
	}else{
		print "OK LOGSPACE max utilized: "maxutil"% < " w "%, currently utilized = "pctutil "% " perf;		
		exit 0;
	}
	print "something is wrong in testscript"
	exit 3;

}'
