#!/bin/bash

#
# show occupation in tsm: number of files and mb.
# for statistical purpose
#
. ${TSM_CHECKS_ENV:-./tsm_checks.env}

w=4
c=2
dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "select sum(num_files) AS FILES,sum(physical_mb) AS MB from occupancy" | grep -v "^AN[R,S]" | awk -v c=$c -v w=$w '
{
	perf=""
	mesg="Occupancy Info OK | "
	perf=sprintf("%s NO_OF_FILES=%s;;;0; MB_OCCUPIED=%s;;;0;",perf,$1,$2); 
	print mesg perf;
	exit 0;
}
'
