#!/bin/bash

#
# 2006 Volker Maibaum volker.maibaum@web.de
#
# Monitors online paths to drives

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

read nr <<EOQ 
$(\
dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes \
"select count(*) from paths where online='YES' and DESTINATION_TYPE='DRIVE'" \
)
EOQ

# Reassigning these mostly to make the following substitution line less wordy.

w=$tsm_paths_w
c=$tsm_paths_c

perf="Online Paths: $nr ($TSM_SERVER) | paths=$nr;$w;$c;0;0"

if  [ $nr -gt $w ] ; then
    echo "OK $perf"
    exit 0;
elif  [ $nr -gt $c ] ; then
    echo "WARNING $perf"
    exit 1;
else
    echo "CRIT $perf"
    exit 2;
fi

echo " SERIOUS ERROR! Should not be reachable.."
exit 3;
