#!/bin/bash

# List number and type of sessions/processes
#
# 2006 Volker Maibaum volker.maibaum@web.de
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

select_cmd="dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes -comma" 

sessions=`$select_cmd "SELECT SESSION_TYPE, COUNT(*) FROM SESSIONS WHERE CLIENT_NAME <> UPPER('$TSM_SELECT_USER') GROUP BY SESSION_TYPE" | awk --field-separator "," ' 
BEGIN{
	Node=0;
	Admin=0;
}
{
	if ($1 == "Node"){
		Node = $2
	}
	if ($1 == "Admin"){
		Admin = $2
	}
}
END{
	print "Admin=" Admin ";;;; Node=" Node ";;;;"
}
'`

sessionperf=$sessions
sessions=`echo $sessions | sed "s/\;\;\;\;//g"`
processes=`$select_cmd "SELECT PROCESS, COUNT(*) FROM PROCESSES GROUP BY PROCESS"| sed "s/ /_/g" | awk -vses="$sessions" -vsesperf="$sessionperf" --field-separator "," '
BEGIN{
        Migration=0;
        Space_Reclamation=0;
	Expiration=0;
	Backup_Storage_Pool=0;
	Database_Backup=0;
}
{
        if ($1 == "Migration"){
                Migration = $2
        }
        if ($1 == "Space_Reclamation"){
                Space_Reclamation = $2
        }
        if ($1 == "Expiration"){
                Expiration = $2
        }
        if ($1 == "Backup_Storage_Pool"){
                Backup_Storage_Pool = $2
        }
        if ($1 == "Database_Backup"){
                Database_Backup = $2
        }
}
END{
        print "Migration=" Migration " Space_Reclamation=" Space_Reclamation " Expiration=" Expiration " Backup_Storage_Pool=" Backup_Storage_Pool " Database_Backup=" Database_Backup " "ses"|Migration=" Migration ";;;; Space_Reclamation=" Space_Reclamation ";;;; Expiration=" Expiration ";;;; Backup_Storage_Pool=" Backup_Storage_Pool ";;;; Database_Backup=" Database_Backup ";;;; "sesperf
}
'`

echo "Processes/Sessions: $processes" 
