#!/bin/bash

#
# Monitors client schedule errors
#
# 2006 Volker Maibaum volker.maibaum@web.de
#

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

errors=`dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -comma -dataonly=yes "q event * * t=c begind=today-1 begint=now endd=today endt=now ex=yes" | awk --field-separator="," '
{
	gsub(" ","",$5);print $4"," $3"," $5
}
' | sort -t "," -k 1,2 | awk --field-separator=","  '
BEGIN{
	node="";
	node_cnt=1;
	n="";
	s="";
	count_all=0;
}

{
	node2=$1$2
        if (node2 != ""){
                count_all++;
        }
	if ( node == ""){
		node = node2;
		n=$1
		s=$2
		r=$3
		node_cnt=0;
	}

	if ( node2 == node ){
		node_cnt++;
	}else{
		if ( node_cnt > 1 ){
			print node_cnt "x" n "(" s "):" r;
		}else{
			print n"("s"):"r;
		}
		node=$1$2
		n=$1
		s=$2
		r=$3
		node_cnt=1;
	}
}
END{
		if ( node_cnt > 1 ){
			print node_cnt "x" n "(" s "):" r;
		}else{
			print n"("s"):"r;
		}
		exit count_all
}
'` 

nr=$? 
errors=`echo $errors`
w=$tsm_schedule_error_w
c=$tsm_schedule_error_c

if [ "$nr" -ge "$c" ]
then
	echo "CRITICAL: $nr schedule error(s): $errors | errors=$nr;$w;$c;0;";
	exit 2;
elif [ "$nr" -ge "$w" ]
then
	echo "WARN: $nr schedule error(s): $errors | errors=$nr;$w;$c;0;";
	exit 1;
elif [ "$nr" -lt "$w" ]
then
	echo "OK: $nr schedule error(s): $errors | errors=$nr;$w;$c;0;";
	exit 0;
else
	echo "UNKNOWN: Error in script - this should not happen ";
	exit 3;
fi
