#!/bin/bash

#
# Show the average server performance for server processes 
# (such as DB_Backup, Migration, etc)
# for statistical purpose
#
#
. ${TSM_CHECKS_ENV:-./tsm_checks.env}

# use sum not avg function, should be more accurate (short processes have not so much weight)
dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "select SUBSTR(activity,1,15), int(cast(sum(bytes) as decimal(18,0)) / cast(sum(end_time-start_time) seconds as decimal(18,0))) as b_per_sec from summary where (activity='FULL_DBBACKUP' or activity='MIGRATION' or activity='STGPOOL BACKUP' or activity='RECLAMATION' or activity='MOVE NODEDATA' or activity='MOVE DATA' or activity='OFFSITE RECLAMATION') and bytes >= 100000000 and start_time>=current_timestamp-30 days group by activity order by b_per_sec"| grep -v "^AN[R,S]" | sed "s/\b \b/_/g" | sed "s/,/./g" | sed "s/ +/ /g"| awk 'BEGIN{

	mesg="Server Performance|";
	perf="";
}
{
       perf=sprintf("%s%s=%s;;;; ", perf,$1,$2); 
}
END{
	print mesg perf;
}
'

#echo "$sum GB Backed up |backup_gb=$sum;0;0;0;0"
exit 0
