#!/bin/bash

#
# Monitors status of volumes
#
. ${TSM_CHECKS_ENV:-./tsm_checks.env}

scratch=`dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT count(*) FROM libvolumes WHERE STATUS='Scratch'" | grep -v "^AN[R,S]" | sed "s/ //g"`
pending=`dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT count(*) FROM volumes WHERE STATUS='PENDING'" | grep -v "^AN[R,S]" | sed "s/ //g"`
filling=`dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT count(*) FROM volumes WHERE STATUS='FILLING'" | grep -v "^AN[R,S]" | sed "s/ //g"`
full=`dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT count(*) FROM volumes WHERE STATUS='FULL'" | grep -v "^AN[R,S]" | sed "s/ //g"`
empty=`dsmadmc -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -displaymode=table -dataonly=yes "SELECT count(*) FROM volumes WHERE STATUS='EMPTY'" | grep -v "^AN[R,S]" | sed "s/ //g"`

msg="Volume States: scratch=$scratch: pending=$pending: filling=$filling: full=$full: empty=$empty"
perf="|scratch=$scratch;;;0; pending=$pending;;;0; filling=$filling;;;0; full=$full;;;0; empty=$empty;;;0;"
rc=0;
echo $msg $perf
exit $rc

