#!/bin/bash

#
# 2006 Volker Maibaum volker.maibaum@web.de
#
# Calculate the number of Volumes that are wasted because of unreclaimed space in stgpools

. ${TSM_CHECKS_ENV:-./tsm_checks.env}

read PCT COUNT WASTED <<EOQ 
$(\
dsmadmc $TSM_SERVER_STANZA -id=$TSM_SELECT_USER -password=$TSM_SELECT_PASS -dataonly=yes \
"select int(avg(pct_reclaim)) AS avg_pct_reclaim, count(*) AS COUNT, int(avg(pct_reclaim))*count(*)/100 AS WASTED_VOLUMES from volumes where status='FULL'" \
)
EOQ

perf="Wasted: $WASTED, Avg Reclaim: $PCT, Full Volumes: $COUNT"
perfdata="|WASTED=$WASTED;;;0; AVG_RECLAIM=$PCT;;;0; FULL_VOLUMES=$COUNT;;;0;"
echo "OK $perf" $perfdata
exit 0;
