#include <iostream>
#include <getopt.h>
#include <string>
#include <modbus/modbus.h>
#include <errno.h>

using namespace std;

void print_help()
{
    cout 
    << "ModBus TCP Reader version 0.01 by Roman Suchkov aka Fineson" << endl 
    << "-h  --help	Print this help" << endl 
    << "-H  --ip=	<IP address>" << endl
    << "-p  --port=	[Port number] Default 502" << endl 
    << "-d  --device=	[Device number] Default 1" << endl
    << "-s  --start=	[Start reference] Default 1" << endl
    << "-l  --len=	[Number of values] Default 1" << endl
    << "-f  --function=	<Number of functions>" << endl
    << " 		1 - Read coils" << endl 
    << " 		2 - Read input discretes" << endl
    << " 		3 - Read multiple registers" << endl
    << " 		4 - Read input registers" << endl << endl
    << " Example: ./modbtget -H 192.168.1.123 --port=1502 -d 1 -s 13 --len=10 -f 4" << endl
    << endl;
}
        
int main(int argc, char **argv)

{

    modbus_t *mb;
    uint8_t tab_reg8[125];
    uint16_t tab_reg16[125];
    int mport = 502; 		// Port number
    int devnum = 1;		// Device number
    int sad = 1;		// Start address
    int nv = 1;			// Length
    int nf;			// Number of function
    int rc;
    int rs;
    int option_index;
    const char* short_options = "hH:p:d:s:l:f:";
    const struct option long_options[] = {
        {"help",no_argument,NULL,'h'},
        {"ip",required_argument,NULL,'H'},
        {"port",optional_argument,NULL,'p'},
        {"device",optional_argument,NULL,'d'},
        {"start",optional_argument,NULL,'s'},
        {"len",optional_argument,NULL,'l'},
        {"function",required_argument,NULL,'f'},
        {NULL,0,NULL,0}
    };
    char *IPad = NULL; 		// IP address

    if (argc < 2) {
	cout << argv[0] << " : Could not parse arguments" << endl;
	print_help(); return 3; };

     while (1) {
	rs=getopt_long(argc,argv,short_options,long_options,&option_index);
        if (rs == -1) break;

        switch(rs){
	    case 'h':
	        print_help(); return 0;
	    case 'H':
		IPad = optarg;
		break;
	    case 'p':
		mport = atoi(optarg);
		break;
	    case 'd':
		devnum = atoi(optarg);
		break;
	    case 's':
		sad = atoi(optarg);
		break;
	    case 'l':
		nv = atoi(optarg);
		break;
	    case 'f':
		nf = atoi(optarg);
		break;
	    case '?': default:
                print_help(); exit (3);
                  };
               };

	if (IPad == NULL) {
    	    cout << argv[0] << " : Could not parse IP address" << endl;
            print_help(); return 3; };

    mb = modbus_new_tcp(IPad, mport);
    if (mb == NULL) {
	cout << "Unable to allocate libmodbus context" << endl;
        return 3;
        }
    if (modbus_connect(mb) == -1) {
	cout << "Connection failed: " << modbus_strerror(errno) << endl;
        modbus_free(mb);
        return 3;
        }

    modbus_set_slave(mb,devnum);
    sad --;

    switch (nf)
    {
    case 1: 
	rc = modbus_read_bits(mb, sad, nv, tab_reg8);
        if (rc == -1) {
    	    cout << "Read failed: " << modbus_strerror(errno) << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
	    }
	for (int i=0; i < rc; i++) {
	    cout << (int)tab_reg8[i] << endl;
//	    printf("reg[%d]=%d \t (%Xb)\n", i+sad+1, tab_reg8[i], tab_reg8[i]);
    	    }
    break;
    case 2: 
        rc = modbus_read_input_bits(mb, sad, nv, tab_reg8);
	if (rc == -1) {
	    cout << "Read failed: " << modbus_strerror(errno) << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
	    }
	for (int i=0; i < rc; i++) {
	    cout << (int)tab_reg8[i] << endl;
//	    printf("reg[%d]=%d \t (%Xb)\n", i+sad+1, tab_reg8[i], tab_reg8[i]);
    	    }
    break;
    case 3: 
        rc = modbus_read_registers(mb, sad, nv, tab_reg16);
	if (rc == -1) {
	    cout << "Read failed: " << modbus_strerror(errno) << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
	    }
	for (int i=0; i < rc; i++) {
	    cout << tab_reg16[i] << endl;
//	    printf("reg[%d]=%d \t (0x%X)\n", i+sad+1, tab_reg16[i], tab_reg16[i]);
    	    }
    break; 
    case 4: 
        rc = modbus_read_input_registers(mb, sad, nv, tab_reg16);
	if (rc == -1) {
	    cout << "Read failed: " << modbus_strerror(errno) << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
	    }
	for (int i=0; i < rc; i++) {
	    cout << tab_reg16[i] << endl;
//	    printf("reg[%d]=%d \t (0x%X)\n", i+sad+1, tab_reg16[i], tab_reg16[i]);
    	    }
    break; 
    default:
	cout << "Invalid function number" << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
    }


    modbus_close(mb);
    modbus_free(mb);

    cin.sync();
    return 0;
}
