#include <iostream>
#include <getopt.h>
#include <string>
#include <modbus/modbus.h>
#include <errno.h>

using namespace std;

void print_help()
{
    cout
    << "ModBus TCP Writer version 0.01 by Roman Suchkov aka Fineson" << endl
    << "-h  --help      Print help" << endl
    << "-H  --ip=       <IP address>" << endl
    << "-p  --port=     [Port number] Default 502" << endl
    << "-d  --device=   [Device number] Default 1" << endl
    << "-a  --address=  [Address reference] Default 1" << endl
    << "-D  --data=     <Data>" << endl
    << "-f  --function= <Number of functions>" << endl
    << "                5 - Write coils" << endl
    << "                6 - Write single registers" << endl << endl
    << " Example: ./modbtset -H 192.168.1.123 -d 1 -a 13 --data=12345 -f 6" << endl
    << endl;
}


int main(int argc, char **argv)
{

    modbus_t *mb;
    uint8_t tab_reg8[1];
    uint16_t tab_reg16[1];
    int mport = 502; 
    int devnum = 1;
    int odat;
    int sad =1;
    int nf;
    int rc;
    int rs;
    int option_index;
    const char* short_options = "hH:p:d:a:D:f:";
    const struct option long_options[] = {
        {"help",no_argument,NULL,'h'},
        {"ip",required_argument,NULL,'H'},
        {"port",optional_argument,NULL,'p'},
        {"device",optional_argument,NULL,'d'},
        {"address",optional_argument,NULL,'a'},
        {"data",required_argument,NULL,'D'},
        {"function",required_argument,NULL,'f'},
        {NULL,0,NULL,0}
    };
    char *IPad = NULL; 

if (argc < 2) {
     cout << argv[0] << " : Could not parse arguments" << endl;
     print_help(); return 3; };

    while (1) {
        rs=getopt_long(argc,argv,short_options,long_options,&option_index);
        if (rs == -1) break;

        switch(rs){
            case 'h':
    		print_help(); return 0;
            case 'H':
                IPad = optarg;
                break;
            case 'p':
                mport = atoi(optarg);
                break;
            case 'd':
                devnum = atoi(optarg);
                break;
            case 'a':
                sad = atoi(optarg);
                break;
            case 'D':
                odat = atoi(optarg);
                break;
            case 'f':
                nf = atoi(optarg);
                break;
            case '?': default:
                print_help(); exit (3);
                };
	    };

	if (IPad == NULL) {
    	    cout << argv[0] << " : Could not parse IP address" << endl;
            print_help(); return 3; };

    mb = modbus_new_tcp(IPad, mport);
    if (mb == NULL) {
	cout << "Unable to allocate libmodbus context" << endl;
        return 3;
        }
    if (modbus_connect(mb) == -1) {
	cout << "Connection failed: " << modbus_strerror(errno) << endl;
        modbus_free(mb);
        return 3;
        }

    modbus_set_slave(mb,devnum);

    sad --;

    switch (nf)
    {
    case 5: 
	rc = modbus_write_bit(mb, sad, odat);
        if (rc == -1) {
    	    cout << "Write failed: " << modbus_strerror(errno) << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
	    }
    break;
    case 6: 
	rc = modbus_write_register(mb, sad, odat);
        if (rc == -1) {
    	    cout << "Write failed: " << modbus_strerror(errno) << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
	    }
    break;
    default:
	cout << "Invalid function number" << endl;
	    modbus_close(mb);
    	    modbus_free(mb);
    	    return 3;
    }

    modbus_close(mb);
    modbus_free(mb);

    cin.sync();
    return 0;
}
