#!/bin/bash
#check_hello_world_via_ssh 0.2 (code name: Heracleum mantegazzianum)



#checks ssh status running "echo hello world" on the remote machine
#I created this plugin to check if the target machine can handle ssh connections. Differently from check_ssh standard plugin, this script will open a connection and run a command. So we can detect machines which are up and running but in weired states, eg: ssh responds but does not load you the prompt

#of course the plugin needs that nagios user has ssh access to the target machine AND that the nagios user has previously exchanged the SSH key with the target
#made by Fabio Pardi on April, 2012 pachistano@gmail.com

#variables definition 

#this is the user that does the login on the target machine
user=httpd     ####this has to be changed from you
exit_code=0
##################################################
#############################################
print_help() {
        echo ""
        echo "Usage: $PROGNAME --help"
	echo "Usage: $PROGNAME -t target IP "
        echo ""
        echo "Plugin to check SSH status"
	echo ""
	echo "PARAMETERS:"
        echo ""
}
##################################################
##############################################
#parameters check
target=0


#do not edit here below. 
if [ $user == "your_user_here" ]  #parameters check. checks for you if you changed the user or not.
then
	echo "Hey, no user is configured. Please edit the plugin and choose an user to use to connect to the server"
	exit 2
fi

while test -n "$1"; do
  case "$1" in
        --help)
            print_help
            exit 2
            ;;

        -t)
            target=$2
            shift
            ;;
	*)
	print_help
	exit 2
	;;
    esac
    shift
done 

if  [ $target == "0" ]   ;then
echo provided target is $target 
echo "please use -t target_ip "
exit
fi

ssh -o ConnectTimeout=5 $user@$target "echo hello world > /dev/null" 
result=$?


if [ $result -eq 0 ]
then
	echo OK 
	exit 0
else
	echo "Cannot complete SSH connection"
	exit 2	
fi
#if we reach this point, it means everything worked out
exit 

		#NAGIOSEXIT
		#exit codes (service status)
		#0=OK
		#1=warning
		#2=critical
