<?PHP

/**
 * Copyright (C) 2006-2012 Heiko Henning <greenrover33@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * nagios status file parser
 */
class nagios {

    /**
     * pathto nagios status database file
     * @var string
     */
    protected $statusfile = '';

    /**
     * list of hosts with parsed status informations
     * @var array
     */
    protected $hosts = array();

    /**
     * list of human readable status codes
     * @var array
     */
    protected $state_array = array();

    /**
     *
     * @param string $statusfile
     */
    public function __construct($statusfile) {
        if (!is_file($statusfile)) {
            trigger_error('nagios::__cosntruct no valid statusfile file given', E_USER_ERROR);
        }

        $this->state_array = array(
            0 => 'OK',
            1 => 'WARN',
            2 => 'CRIT',
            3 => 'UNK',
            999 => 'OFF',
            998 => 'NOTSET'
        );

        $this->statusfile = $statusfile;
        $this->parse_statusfile();
    }

    /**
     * get status message by hostname
     * @param string $host_name
     * @return string
     */
    public function get_status_text($host_name) {
        $txt = $host_name . "\n";

        foreach ($this->hosts[$host_name] AS $service => $status) {
            if ($status['status'] != 'OK') {
                $txt.=$service . '=' . $status['status'] . ' ' . substr(strtr($status['plugin_output'], array('CRITICAL ' => '')), 0, 35) . "\n";
            } else {
                $txt.=$service . '=' . $status['status'] . "\n";
            }
        }

        return $txt;
    }

    /**
     * get status by hostname
     * @param string $host_name
     * @return string
     */
    public function get_status($host_name) {
        $status = 'OK';

        foreach ($this->hosts[$host_name] AS $service => $status) {
            if ($status['status'] != 'OK' && $status != 'CRIT') {
                $status = $status['status'];
            }
        }

        return $status;
    }

    /**
     * parse given statusfile
     */
    protected function parse_statusfile() {
        preg_match_all('/\n([a-z]+) \{(.*)\}/sSU', file_get_contents($this->statusfile), $fd
        );
        $this->hosts = array();
        $to_notify = array();

        foreach ($fd[1] As $i => $o) {
            $data = array();
            foreach (explode("\n", $fd[2][$i]) AS $row) {
                $k = explode('=', trim($row), 2);
                if (isset($k[1])) {
                    $data[$k[0]] = $k[1];
                }
            }

            if (!isset($data['current_state']))
                $data['current_state'] = 998;

            switch ($o) {
                case 'servicestatus':
                    if ($data['service_description']) {
                        $this->hosts[$data['host_name']][$data['service_description']] = array('status' => $this->state_array[$data['current_state']],
                            'plugin_output' => $data['plugin_output']
                        );
                    }
                    break;

                case 'hoststatus':
                    $this->hosts[$data['host_name']]['general'] = array('status' => $this->state_array[@$data['current_state']],
                        'plugin_output' => $data['plugin_output']
                    );
                    break;
            }
        }
    }

}

?>
