<?php

/**
 * Copyright (C) 2002-2004 Oliver Hitz <oliver@net-track.ch>
 *
 * $Id: SMS.inc,v 1.4 2005/01/17 15:34:19 oli Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

class sms {

    protected $userkey;
    protected $password;
    protected $originator;
    protected $recipients;
    protected $content;
    protected $blinking;
    protected $flashing;
    protected $debug;
    protected $mcc;
    protected $mnc;
    protected $logo;
    protected $timeout;
    protected $servers;
    protected $notification;
    protected $result = array();
    protected $nextResult = '';

    public function __construct($u, $p) {
        $this->userkey = $u;
        $this->password = $p;
        $this->recipients = array();
        $this->blinking = false;
        $this->flashing = false;
        $this->originator = '';
        $this->debug = 0;
        $this->timeout = 2;
        $this->notification = array();

        $this->servers = array(
            'xml1.aspsms.com:5061',
            'xml1.aspsms.com:5098',
            'xml2.aspsms.com:5061',
            'xml2.aspsms.com:5098'
        );
    }

    public function setTimeout($t) {
        $this->timeout = $t;
    }

    public function setOriginator($o) {
        $this->originator = $o;
    }

    public function addRecipient($r, $id = null) {
        $this->recipients[] = array('number' => $r,
            'transaction' => $id
        );
    }

    public function setMCC($mcc) {
        $this->mcc = $mcc;
    }

    public function setMNC($mnc) {
        $this->mnc = $mnc;
    }

    public function setLogo($logo) {
        $this->logo = $logo;
    }

    public function setContent($content, $parse = false) {
        if ($parse) {
            $this->content = '';
            $in = false;
            for ($i = 0; $i < strlen($content); $i++) {
                $c = $content[$i];
                if ($c == '[' && !$in) {
                    $this->content .= '<blink>';
                    $in = true;
                    $this->blinking = true;
                } else if ($c == ']' && $in) {
                    $this->content .= '</blink>';
                    $in = false;
                } else {
                    $this->content .= $c;
                }
            }
        } else {
            $this->content = $content;
        }
    }

    public function setFlashing() {
        $this->flashing = true;
    }

    public function setBufferedNotificationURL($url) {
        $this->notification['buffered'] = $url;
    }

    public function setDeliveryNotificationURL($url) {
        $this->notification['delivery'] = $url;
    }

    public function setNonDeliveryNotificationURL($url) {
        $this->notification['nondelivery'] = $url;
    }

    protected function getXML($content, $action) {
        $originator = '';
        if ($this->originator != '') {
            $originator = sprintf("  <Originator>%s</Originator>\r\n", $this->originator);
        }

        $recipients = '';
        if (count($this->recipients) > 0) {
            foreach ($this->recipients as $re) {
                if ($re['transaction'] != null) {
                    $recipients .= sprintf(
                            "  <Recipient>\r\n" .
                            "    <PhoneNumber>%s</PhoneNumber>\r\n" .
                            "    <TransRefNumber>%s</TransRefNumber>\r\n" .
                            "  </Recipient>\r\n", htmlspecialchars($re['number']), htmlspecialchars($re['transaction']));
                } else {
                    $recipients .= sprintf(
                            "  <Recipient>\r\n" .
                            "    <PhoneNumber>%s</PhoneNumber>\r\n" .
                            "  </Recipient>\r\n", htmlspecialchars($re['number']));
                }
            }
        }

        $notify = '';
        if (isset($this->notification['buffered'])) {
            $notify .= sprintf("  <URLBufferedMessageNotification>%s</URLBufferedMessageNotification>\r\n", htmlspecialchars($this->notification['buffered']));
        }
        if (isset($this->notification['delivery'])) {
            $notify .= sprintf("  <URLDeliveryNotification>%s</URLDeliveryNotification>\r\n", htmlspecialchars($this->notification['delivery']));
        }
        if (isset($this->notification['nondelivery'])) {
            $notify .= sprintf("  <URLNonDeliveryNotification>%s</URLNonDeliveryNotification>\r\n", htmlspecialchars($this->notification['nondelivery']));
        }

        return sprintf("<?xml version= \"1.0\" encoding=\"ISO-8859-1\"?>\r\n" .
                        "<aspsms>\r\n" .
                        "  <Userkey>%s</Userkey>\r\n" .
                        "  <Password>%s</Password>\r\n" .
                        '%s%s%s%s%s' .
                        "  %s\r\n" .
                        "  <Action>%s</Action>\r\n" .
                        "</aspsms>\n", $this->userkey, $this->password, $originator, $this->flashing ? '  <FlashingSMS>1</FlashingSMS>\r\n' : '', $this->blinking ? '  <BlinkingSMS>1</BlinkingSMS>\r\n' : '', $recipients, $notify, $content, $action);
    }

    public function setDebug() {
        $this->debug = 1;
    }

    public function sendVCard($name, $phone) {
        $content = sprintf('<VCard><VName>%s</VName><VPhoneNumber>%s</VPhoneNumber></VCard>', htmlspecialchars($name), htmlspecialchars($phone));
        return $this->send($this->getXML($content, 'SendVCard'));
    }

    public function sendSMS() {
        return $this->send($this->getXML('<MessageData>' . htmlspecialchars($this->content) . '</MessageData>', 'SendTextSMS'));
    }

    public function sendLogo() {
        $c = sprintf('<MCC>%s</MCC><MNC>%s</MNC><URLBinaryFile>%s</URLBinaryFile>', $this->mcc, $this->mnc, $this->logo);
        return $this->send($this->getXML($c, 'SendLogo'));
    }

    public function showCredits() {
        return $this->send($this->getXML('', 'ShowCredits'));
    }

    protected function send($msg) {
        foreach ($this->servers as $server) {
            list($host, $port) = explode(':', $server);
            $result = $this->sendToServer($msg, $host, $port);
            if ($result == 1) {
                return $result;
            }
        }
        return 0;
    }

    protected function sendToServer($msg, $host, $port) {
        if ($this->debug) {
            print '<pre>';
            print nl2br(htmlentities($msg));
            print '</pre>';
            return 1;
        } else {
            $errno = 0;
            $errdesc = 0;
            $fp = fsockopen($host, $port, $errno, $errdesc, $this->timeout);
            if ($fp) {
                fputs($fp, "POST /xmlsvr.asp HTTP/1.0\r\n");
                fputs($fp, "Content-Type: text/xml\r\n");
                fputs($fp, 'Content-Length: ' . strlen($msg) . "\r\n");
                fputs($fp, "\r\n");
                fputs($fp, $msg);

                $content = 0;
                $reply = array();
                while (!feof($fp)) {
                    $r = fgets($fp, 1024);
                    if ($content) {
                        $reply[] = $r;
                    } else {
                        if (trim($r) == '') {
                            $content = 1;
                        }
                    }
                }

                fclose($fp);
                $this->parseResult(implode('', $reply));
                return $this->result['ErrorCode'];
            } else {
                $this->result['ErrorCode'] = 0;
                $this->result['ErrorDescription'] = 'Unable to connect to ' . $host . ':' . $port . ' ' . date('d.m.Y H:i:s', time());
                return 0;
            }
        }
    }

    public function getErrorCode() {
        return $this->result['ErrorCode'];
    }

    public function getErrorDescription() {
        return $this->result['ErrorDescription'];
    }

    public function getCredits() {
        return $this->result['Credits'];
    }

    protected function startElement($parser, $name, $attrs) {
        if ($name == 'ErrorCode' || $name == 'ErrorDescription' || $name == 'Credits') {
            $this->nextResult = $name;
        }
    }

    protected function endElement($parser, $name) {
        $this->nextResult = '';
    }

    protected function characterData($parser, $data) {
        if ($this->nextResult != '') {
            $this->result[$this->nextResult] .= $data;
        }
    }

    protected function parseResult($result) {
        // Clear the result
        $this->result = array(
            'ErrorCode' => 0,
            'ErrorDescription' => '',
            'Credits' => ''
        );

        $p = xml_parser_create();
        xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, false);
        xml_set_element_handler($p, array(&$this, 'startElement'), array(&$this, 'endElement'));
        xml_set_character_data_handler($p, array(&$this, 'characterData'));
        if (!xml_parse($p, $result, true)) {
            $this->result['ErrorCode'] = 0;
            $this->result['ErrorDescription'] = 'Unable to parse result.';
        }
        xml_parser_free($p);
    }

}

?>
