#!/usr/bin/perl -w

use strict;

# begin of configuration part

# 1st some basic settings, pathes and user/password. Change as needed
# your sqlplus with absolute path
my $SQLPLUS='/export/home/oracle/product/ora11gR2/bin/sqlplus';
# USER/PASSWORD, .e.g. MASTER/SYSTEM or ' / as sysdba'.
my $CONNECT='MASTER/SYSTEM ';
# Output file with absolute path. Must be readable by user nagios.
my $OUTFILE='/export/home/oracle/yaonp.dat';

# 2nd, the main check conditions
# each check consists of three entries in three arrays
# NAME - name of the check.
# ACTIVE - wether the check will be executed. To disable, set to 'no'.
# SQL - SQL-Statement to get the data and print the formatted output.
# Format is CHECK|VALUE|[NAME]|[OUTPUT]|[PERFDATA]
# CHECK - Name of the check from $NAME[$ID]. Important for yaonp-plugin.pl to get the requested value.
# VALUE - Result of the SQL, should be only a number. In best case only one row. The higher the value, the more worse the situation. Count misses, not hits.
# NAME - For multiline results, e.g. available tablespaces, NAME is the name of the tablespace
# OUTPUT - any additional output which may be helpful to solve an alert.
# PERFDATA - template for performance data. Only the template, values will be filled in by the "plugin" part. Template consists of
#            label=unit of work. 
# delimeter is the '|'-symbol
# to add a simple check (only one value per row) paste " \'CHECK\'||\'|\'|| " directly after the "SELECT"
# and " || \'|\'||\'|\'||\'|\' " before the "FROM". If needed, don't forget the template for performance data.

my @NAME;
my @ACTIVE;
my @SQL;

# Dictionary Cache Miss Ratio
$NAME[0]='dictcachmisses';
$ACTIVE[0]='yes';
$SQL[0]='SELECT \'dictcachmisses\'||\'|\'||ROUND((1 - (Sum(gets)/(Sum(gets) + Sum(getmisses)))) * 100, 1) || \'|\'||\'|\'||\'|Dict Cache Miss Ratio=%|\' FROM v$rowcache;';
# Library Cache Miss Ratio
$NAME[1]='libcachmisses';
$ACTIVE[1]='yes';
$SQL[1]='SELECT \'libcachmisses\'||\'|\'||ROUND((1 -(Sum(pins)/(Sum(pins) + Sum(reloads)))) * 100, 1) || \'|\'||\'|\'||\'|Lib Cache Miss Ratio=%|\' FROM v$librarycache;';
# DB Block Buffer Cache Miss Ratio
$NAME[2]='dbblckbufmisses';
$ACTIVE[2]='yes';
$SQL[2]='SELECT \'dbblckbufmisses\'||\'|\'||ROUND(((phys.value / (db.value + cons.value))) * 100, 1) || \'|\'||\'|\'||\'|Block Buffer Cache Miss=%|\' FROM v$sysstat phys, v$sysstat db, v$sysstat cons WHERE  phys.name  = \'physical reads\' AND db.name = \'db block gets\' AND cons.name  = \'consistent gets\';';
# redo buffer allocation entries/retries ratio
$NAME[3]='redoentryretr';
$ACTIVE[3]='yes';
$SQL[3]='SELECT \'redoentryretr\'||\'|\'||ROUND((retries.value/entries.value) * 100, 1) || \'|\'||\'|\'||\'|redo buff alloc entries/retries=%|\' FROM v$sysstat retries, v$sysstat entries WHERE retries.name = \'redo buffer allocation retries\' AND entries.name  = \'redo entries\';';
# Latch Miss Ratio
$NAME[4]='latchmisses';
$ACTIVE[4]='yes';
$SQL[4]='SELECT \'latchmisses\'||\'|\'||ROUND((Sum(misses) / Sum(gets)) * 100, 1) || \'|\'||\'|\'||\'|Latch Miss=%|\' FROM v$latch;';
# Disk Sort Ratio
$NAME[5]='disksorts';
$ACTIVE[5]='yes';
$SQL[5]='SELECT \'disksorts\'||\'|\'||(disk.value/mem.value) * 100 || \'|\'||\'|\'||\'|Disk Sort=%|\' FROM v$sysstat disk, v$sysstat mem WHERE disk.name = \'sorts (disk)\' AND mem.name  = \'sorts (memory)\';';
# Rollback Segment Waits
$NAME[6]='rollbckwa';
$ACTIVE[6]='yes';
$SQL[6]='SELECT \'rollbckwa\'||\'|\'||ROUND((Sum(waits) / Sum(gets)) * 100, 1) || \'|\'||\'|\'||\'|Rollback Segment Waits=%|\' FROM v$rollstat;';
# Dispatcher Workload
$NAME[7]='dispworkl';
$ACTIVE[7]='yes';
$SQL[7]='SELECT \'dispworkl\'||\'|\'||ROUND(NVL((Sum(busy) / (Sum(busy) + Sum(idle))) * 100,0), 1) || \'|\'||\'|\'||\'|Dispatcher Workload=%|\' FROM v$dispatcher;';
# Count Sessions
$NAME[8]='numsessions';
$ACTIVE[8]='yes';
$SQL[8]='SELECT \'numsessions\'||\'|\'||COUNT(*) || \'|\'||\'|\'||\'|Count Sessions=|\' FROM v$session;';
# Number of locked objects
$NAME[9]='numlckedobj';
$ACTIVE[9]='yes';
$SQL[9]='SELECT \'numlckedobj\'||\'|\'||COUNT(*) || \'|\'||\'|\'||\'|Number of locked objects=|\' FROM v$locked_object;';
# Number of locks blocking other locks
$NAME[10]='numlckblcklck';
$ACTIVE[10]='yes';
$SQL[10]='SELECT \'numlckblcklck\'||\'|\'||COUNT(*) || \'|\'||\'|\'||\'|Number of locks blocking other locks=|\' FROM v$lock WHERE block != 0;';
# Number of sessions blocked by other sessions longer than a minute
$NAME[11]='numblcksess';
$ACTIVE[11]='yes';
$SQL[11]='SELECT \'numblcksess\'||\'|\'||COUNT(blocking_session) || \'|\'||\'|\'||\'|Number of sessions blocked by other sessions=|\' FROM v$session WHERE blocking_session IS NOT NULL and seconds_in_wait > 60; ';
# Tablespace Usage
$NAME[12]='tbspcuse';
$ACTIVE[12]='yes';
$SQL[12]='SELECT \'tbspcuse\'||\'|\'||ROUND(USED_PERCENT)||\'|\'||TABLESPACE_NAME||\'|\'||\'|Tablespace Usage=%|\' FROM dba_tablespace_usage_metrics;';

# end  of configuration part

# other variables. Don't touch if you don't know what you do!
my $I='0';
my $SQL;

# calling sqlplus and starting main loop
open ORA, "| $SQLPLUS -s $CONNECT" or die "Can't pipe to sqlplus: $!";
print ORA "set pagesize 0\n";
print ORA "set trimspool on\n";
print ORA "set numformat 999.99\n";
print ORA "set pagesize 0\n";
print ORA "set feedback off\n";
print ORA "set linesize 9999\n";
print ORA "spool $OUTFILE\n";
foreach $SQL(@SQL){
   if($ACTIVE[$I] eq 'yes'){
      print ORA "$SQL[$I]\n";
      $I++;
   }else{
      $I++;
      }
   }
print ORA "exit\n";
close ORA;

