#!/usr/bin/perl -w

use strict;

# begin of configuration part

# 1st some basic settings, path to the output file of the "collector" and the cycle in seconds in which new dat files will be created
my $DATE='/usr/bin/date';
my $OUTFILE='/export/home/oracle/yaonp.dat';
my $CYCLE=300;

# end of configuration part. Don't touch the following lines if you don't know what you do!
my $ARGC=$#ARGV + 1;
my $TIMESTAMP;
my $MTIME;
my $TEST;
my $VALUE;
my $NAME='';
my $OUTPUT;
my $WARN;
my $CRIT;
my $FILEAGE;
my $OUTOLD='no';
# $OUT*-variables are containing values from OUTFILE
my $OUTTEST;
my $OUTVALUE;
my $OUTNAME='';
my $OUTOUTPUT='';
my $PERFTPL;
my $LABEL;
my $UOW;
my $ORAERR='';
my $TEMP;


# check for argument count
$ARGC=$#ARGV + 1;
if(($ARGC > 6) || ($ARGC < 5)){
   print "$NAME UNKNOWN: wrong commandline parameters - exiting\n";
   print "USAGE: yaonp-plugin.pl TEST [NAME] -w WARNVALUE -c CRITVALUE\n";
   exit 3;
   }

# assigning parameters to variables
$TEST=$ARGV[0];
if($ARGC==6){
   $NAME=$ARGV[1];
   if($ARGV[2] eq '-w'){
      $WARN=$ARGV[3];
   }else{
      print "$NAME UNKNOWN: wrong commandline parameters - exiting\n";
      print "USAGE: yaonp-plugin.pl TEST [NAME] -w WARNVALUE -c CRITVALUE\n";
      exit 3;
      }
   if($ARGV[4] eq '-c'){
      $CRIT=$ARGV[5];
   }else{
      print "$NAME UNKNOWN: wrong commandline parameters - exiting\n";
      print "USAGE: yaonp-plugin.pl TEST [NAME] -w WARNVALUE -c CRITVALUE\n";
      exit 3;
      }
}else{
   if($ARGV[1] eq '-w'){
      $WARN=$ARGV[2];
   }else{
      print "$NAME UNKNOWN: wrong commandline parameters - exiting\n";
      print "USAGE: yaonp-plugin.pl TEST [NAME] -w WARNVALUE -c CRITVALUE\n";
      exit 3;
      }
   if($ARGV[3] eq '-c'){
      $CRIT=$ARGV[4];
   }else{
      print "$NAME UNKNOWN: wrong commandline parameters - exiting\n";
      print "USAGE: yaonp-plugin.pl TEST [NAME] -w WARNVALUE -c CRITVALUE\n";
      exit 3;
      }
   }

# generating timestamp
$TIMESTAMP = `$DATE +"%Y%m%d%T"`;
chomp $TIMESTAMP;
$TIMESTAMP =~ s/://g;
$TIMESTAMP=time;

# check if outfile exists
if(!-e "$OUTFILE"){
   print "$NAME UNKNOWN: no outfile\n";
   exit 3;
   }

# check age of outfile
$MTIME = (stat($OUTFILE))[9];
$FILEAGE=$TIMESTAMP-$MTIME;
$TEMP=2*$CYCLE;
if($FILEAGE >= $TEMP){
   print "$NAME CRITICAL: File to old\n";
   exit 2;
   }
$TEMP=$CYCLE;
if($FILEAGE >= $TEMP){
   $OUTOLD='yes';
   }

# read outfile
open OUTFILE, "<$OUTFILE" or die $!;
while (<OUTFILE>){
   chomp $_;
   ( $OUTTEST, $OUTVALUE, $OUTNAME, $OUTOUTPUT, $PERFTPL ) = split(/\|/, $_);
   # splitting performance data template
   ( $LABEL, $UOW ) = split(/=/, $PERFTPL);
   if($OUTOUTPUT eq ''){
      $OUTOUTPUT=$LABEL;
      }
   if(($TEST eq $OUTTEST) && ($NAME eq $OUTNAME)){
      # checking values and setting status
      if($OUTVALUE >= $CRIT){
         print "$NAME CRITICAL: $OUTVALUE$UOW $OUTNAME $OUTOUTPUT\|\'$LABEL\'=$OUTVALUE$UOW\n";
         exit 2;
      }elsif($OUTVALUE >= $WARN){
         if($OUTOLD eq 'yes'){
            $OUTOUTPUT='outfile rather old';
            }
         print "$NAME WARNING: $OUTVALUE$UOW $OUTNAME $OUTOUTPUT\|\'$LABEL\'=$OUTVALUE$UOW\n";
         exit 1;
      }else{
        print "$NAME OK: $OUTVALUE$UOW $OUTNAME $OUTOUTPUT\|\'$LABEL\'=$OUTVALUE$UOW\n";
        exit 0;
        }
   }elsif(($ORAERR eq '') && ($OUTTEST =~ m/ORA/)){
      $ORAERR=$OUTTEST;
      }
   }
close(OUTFILE);

# all lines done, no line matches our TEST(/NAME combination). If there was an ORA-error, this might be the cause
if($ORAERR ne ''){
   $OUTVALUE=$CRIT;
   $OUTOUTPUT=$ORAERR;
   print "$NAME CRITICAL: $OUTVALUE $OUTNAME $OUTOUTPUT\n";
   exit 2;
}else{
   $OUTVALUE=$CRIT;
   $OUTOUTPUT="no values for test found. Please check!\n";
   print "$NAME CRITICAL: $OUTVALUE $OUTNAME $OUTOUTPUT\n";
   exit 2;
   }
