' =========================================================
' Script to read cpu temperatures using openhardwaremonitorreport.exe
' arguments :
'  /w : warning level
'  /c : critical level
'  /i : tempid to ignore seperated by ,
' =========================================================

dim output
 
set output = wscript.stdout

' Required Variables
Const PROGNAME = "check_temperature"
Const VERSION = "0.0.1"

' Default settings for your script.
openHardwareMonitorcmd = "C:\Program Files\NSClient++\scripts\OpenHardwareMonitorReport.exe"


'Cons for return val's
Const OK = 0
Const WARNING = 1
Const CRITICAL = 2
Const UNKNOWN = 3



Set Args = WScript.Arguments
If (Args.Count > 0) then
	strSpeedfanLogPath= Args.Item(0)
End If

intTempWarning =  55
intTempCritical =  70
intTempId = 0

intMaxTemp = -99
stringTemperatures = ""
stringTemperatureIgnoreIds = ""

return_code = UNKNOWN
msg = "Error while executing OpenHardwareMonitorReport.exe"

' If we define /warning /critical on commandline it should override the script default.
If Args.Named.Exists("w") Then intTemperatureWarning = Args.Named("w")
If Args.Named.Exists("c") Then intTemperatureCritical = Args.Named("c")
If Args.Named.Exists("i") Then stringTemperatureIgnoreIds = Args.Named("i")

stringTemperatureIgnoreIds = "," + stringTemperatureIgnoreIds

Set objShell = WScript.CreateObject("WScript.Shell")
Set objExecObject = objShell.Exec(openHardwareMonitorcmd)

Do While Not objExecObject.StdOut.AtEndOfStream
	strLine = objExecObject.StdOut.ReadLine()
	if (Instr(strLine,"temperature") > 0 ) then  
	    if (Instr(strLine,":") > 0 ) then  
		strline = Right (strLine, len (strline) - Instr(strLine,":"))
		strline = Ltrim (strLine)
		strline = Left (strLine, Instr(strLine," ") - 1)

		if (Instr(stringTemperatureIgnoreIds, "," + cstr(intTempId)) > 0 ) then  
			stringTemperatures = stringTemperatures + " " +  cstr(intTempId ) + ":" +  strline + "*,"
		else
			if strline > intMaxTemp then
				intMaxTemp = strline
			end if
			stringTemperatures = stringTemperatures + " " +  cstr(intTempId ) + ":" +  strline + ","
		end if
		intTempId  = intTempId  + 1
	    end if
	end if
Loop
stringTemperatures = Left (stringTemperatures, len (stringTemperatures) - 1)


if (intMaxTemp < intTemperatureWarning) then return_code = OK
if (intMaxTemp >= intTemperatureWarning) then return_code = WARNING
if (intMaxTemp >= intTemperatureCritical) then return_code = CRITICAL
if (intMaxTemp < 0) then return_code = UNKNOWN

' Nice Exit with msg and exitcode
output.writeline "Max Cpu Temperature: " + cstr(intMaxTemp) + "       Measured CPU Temperatures:"+ stringTemperatures + "    (* = ignored) "
WScript.quit return_code
