#!/bin/bash


##########################################################
#
#  Nagios check fr Cisco Wireless Lan Controller 5500 Series
#
#  Version 1.0 19.09.2012
#
#  Ausgabe der APs und der angemeldeten User
#
#  Erstellt von Manfred Brunner
#
#  mannybrunner@yahoo.de
#
###########################################################


## Start APs
#
#  APs auslesen mit: snmpwalk -c public 10.104.18.5 -On -v 2c 1.3.6.1.4.1.14179.2.2.1.1.3 | awk '{print $4 " " $1} ' | sort -nr
#  Read out the APs OID with : snmpwalk -c public 10.104.18.5 -On -v 2c 1.3.6.1.4.1.14179.2.2.1.1.3 | awk '{print $4 " " $1} ' | sort -nr
# 
#  you can use also the comand Check_Cisco_WLC.sh -H (hostipadress) -M 1 
#  than you recive a new vile MIB.log with all OIDs and AP names
#
#  und unten in liste definieren als APid[10] - APid[11] -APid12[] .....
#  insert the oids in the list and  add ".0" ad the end of the oid.


APid[1]=".0.14.132.171.8.128.0"                 # dlbruap002
APid[2]=".0.15.247.235.80.0"                    # dlbruap007
APid[3]=".0.24.186.50.191.16"                   # dlbruap005
APid[4]=".0.31.157.33.45.48.0"                  # dlbruap006
APid[5]=".0.31.157.33.52.16.0"                  # dlbruap009
APid[6]=".0.31.157.33.76.112.0"                 # dlbruap008
APid[7]=".0.31.157.33.68.192.0"                 # dlbruap001
APid[8]=".44.63.56.49.84.176.0"                 # dlbruap010
APid[9]=".100.160.231.248.169.160.0"            # dlbruap011
APid[10]=".0.26.48.231.24.32.0"                 # dlbruap003
APid[11]=".44.63.56.43.167.96.0"                # dlbruap013
APid[12]=".0.14.215.189.67.64"                  # dlbruap022
APid[13]=".0.15.52.125.159.48"                  # dlbruap014
APid[14]=".0.15.52.213.163.192"                 # dlbruap019
APid[15]=".0.15.52.215.15.64"                   # dlbruap024
APid[16]=".0.15.247.191.48.160"                 # dlbruap018
APid[17]=".0.15.247.249.120.48"                 # dlbruap023
APid[18]=".0.17.32.6.191.112"                   # dlbruap020
APid[19]=".0.24.186.50.127.160"                 # dlbruap021
APid[20]=".0.31.157.33.57.112.0"                # dlbruap015
APid[21]=".0.31.157.33.71.16.0"                 # dlbruap017
APid[22]=".0.31.157.33.77.0.0"                  # dlbruap016
APid[23]=".0.31.157.33.69.16.0"                 # dlbruap004
maxind=23

#
#
#Ad APs definition

oid_AP_NumOfClients="1.3.6.1.4.1.14179.2.2.13.1.4"
oid_AP_Name="1.3.6.1.4.1.14179.2.2.1.1.3"
oid_AP_Place="1.3.6.1.4.1.14179.2.2.1.1.4"
oid_AP_Firmware="1.3.6.1.4.1.14179.2.2.1.1.16"
oid_AP_IP="1.3.6.1.4.1.14179.2.2.1.1.19"
oid_AP_cannel="1.3.6.1.4.1.14179.2.2.2.1.4"


for parameter in $*; do
        if [ -n "$NEXT" ]
        then
          case "$NEXT" in
          host)
              host=$parameter
              NEXT=""
          ;;
          community)
              community=$parameter
              NEXT=""
          ;;
          version)
              version=$parameter
              NEXT=""
          ;;
          AP)
              AP=$parameter
              NEXT=""
          ;;
          warn)
              warn=$parameter
              NEXT=""
          ;;
          crit)
              crit=$parameter
              NEXT=""
          ;;
          MIB)
             MIB=$parameter
             NEXT=""
          ;;
          esac
        fi

        case "$parameter" in
            -h)
                       echo "Use -H(host) -C(community) -v(version) -A(NO OID definiert in script) -w(warnig) -c(critical) "
                       exit 0
                        ;;
            -H)
               NEXT="host"
                ;;
            -C)
               NEXT="community"
                ;;
            -v)
               NEXT="version"
                ;;
            -A)
               NEXT="AP"
               ;;
            -w)
               NEXT="warn"
               ;;
            -c)
               NEXT="crit"
              ;;
            -M)
              NEXT="MIB"
              ;;
             *)
              ;;
          esac
done



if [ "$MIB" == "1" ];then
        echo "The file with the APS ID  file create successful Path= ./mib.log"
        echo "Please inserte the oids in the OID Section"
        snmpwalk -c public $host -On -v 2c 1.3.6.1.4.1.14179.2.2.1.1.3 | awk '{print $4 " " $1} ' | sort -nr > mib.log
        exit 0
fi


if [ "$host" == "" ];then
        echo "No host defined option -H"
        exit 3
fi

if [ "$community" == "" ];then
        echo "No community defined option -C"
        exit 3
fi

if [ "$version" == "" ];then
        echo "No version defined option -v"
        exit 3
fi

if [ "$AP" == "" ];then
        echo "No AP defined option -A"
        exit 3
fi

if [ "$warn" == "" ];then
        echo "No warning defined option -w"
        exit 3
fi

if [ "$crit" == "" ];then
        echo "No critical defined option -c"
        exit 3
fi


if [ "$crit" -le "$warn" ];then
        echo "Warning level must by lower than critical level!"
        exit 3
fi





####  Aray APS auslesen und in Varbale  APA schreiben

if [ $AP -le $maxind -a $AP -gt 0 ]
then APA="${APid[${AP}]}"
else echo "Index out of Range index="$AP
exit 3
fi


AP_temp=`echo ${APA} | awk '{ if (substr($0, length - 1 , 2) == ".0") print(substr($0, 1, length - 2)); else print }'`

Clients=$(snmpwalk -c $community $host -v $version -Ovq $oid_AP_NumOfClients$APA)

temp1=".1"

${Clients1=$(snmpwalk -c $community $host -v $version -Ovq $oid_AP_NumOfClients$AP_temp$temp1)}
RC=$?
    if [ ${RC} -ne 0 ]
    then
        Clients1=0
    fi
	
AllClients=$(( $Clients+$Clients1 ))

APName=$(snmpwalk -c $community $host -v $version  -Ovq $oid_AP_Name$AP_temp)

APPlace=$(snmpwalk -c $community $host -v $version -Ovq $oid_AP_Place$AP_temp)

APIP=$(snmpwalk -c $community $host -v $version -Ovq $oid_AP_IP$AP_temp)

APFIRM=$(snmpwalk -c $community $host -v $version -Ovq $oid_AP_Firmware$AP_temp)

APCAN=$(snmpwalk -c $community $host -v $version -Ovq $oid_AP_cannel$APA)

ausgabe="$ALLClients client/s are connectet on $APName / $APPlace / Cannel $APCAN  \n Firmware $APFIRM  IP-Adress $APIP "



if [ "$Clients" -gt "$warn" ];then
        echo -e  "WARNING - $ausgabe |  'Clients'=$Clients;$warn;$crit;0;100"
        exit 1
fi


if  [ "$Clients" -gt "$warn" -o "$crit" ];then
        echo -e  "OK - $ausgabe |  'Clients'=$Clients;$warn;$crit;0;100"
        exit 0
fi



if  [ "$Clients" -gt "$crit" ];then
        echo -e   "CRITICAL -  $ausgabe | 'Clients'=$Clients;$warn;$crit;0;100"
        exit 2

else    echo  "CRITICAL - AP not found  | 'Clients'=0;$warn;$crit;0;100"
        exit 2
fi



echo  "CRITICAL - AP not found"
exit 3