#!/usr/bin/perl
# nagios: -epn
## $Id: check_capteurs,v 1.5 2013/03/17 10:00:00 Jean-Philippe LEMOINE $

## Nagios Plugin for read sensors
## 

## 
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# what's new :
# version 1.5
#  - supress several bugs
#  - add performance data
#     to be uses with pnp4nagios (maybe other but not tested)
#     output is <nagios output>|label=<current value><unit if any>;<warn value>;<critical value>

use strict;
use warnings;
use Switch;
use Config::INI::Reader;
use Nagios::Plugin;
use vars qw/ $VERSION /;
use lib "/usr/lib/perl5/B";

$VERSION = '1.5';
my $LICENCE = 'gratuite';

$VERSION = '';
$LICENCE = '';

# *** plugin object  allocation ***
my $plugin_nagios = Nagios::Plugin->new(
  shortname => 'Verification fichier',
  usage     => 'Usage : %s [-f <file> ou --file <file>]',
  version   => $VERSION,
  license   => $LICENCE,
);

# *** parameter reading from command line ****

#1st param = PC NAME (M) (mandatory)
$plugin_nagios->add_arg(
  spec     => 'machine|device|d|m=s',
  help     => 'device to check',    # help for this option
  required => 1,                  # mandatory (1) or optional (0)
);
# machine / m argument stand for compatibility with previous version
# it wil be deprecated in the next version

#2nd param = SENSOR NUMBER (N) (mandatory)
$plugin_nagios->add_arg(
  spec     => 'no_cpt|n=s',
  help     => 'sensors number',    # help for this option
  required => 1,                  # mandatory (1) or optional (0)
);

#3nd param = LANGUAGE (L) (optional)
$plugin_nagios->add_arg(
  spec     => 'lang|l=s',
  help     => 'language (\'en\' or \'fr\')',    # help for this option
  required => 0,                  # mandatory (1) or optional (0)
);

#4th param = PERFORMANCE DATA INDICATOR (D) (optional)
$plugin_nagios->add_arg(
  spec     => 'perf|p!',
  help     => 'performance datat to be send (--perf ou -p) or not (--no-perf)',    # help for this option
  required => 0,                  # mandatory (1) or optional (0)
);


$plugin_nagios->getopts();
# 1st parameter : PC BIOS NAME
my $PC = $plugin_nagios->opts->get('machine');
# 2nd parameter : NUMBER OF THE SENSOR TO BE CHECKED
my $NO = $plugin_nagios->opts->get('no_cpt');
# 3rd parameter (optionnal) : COUNTRY CODE
my $COUNTRY_CODE= $plugin_nagios->opts->get('lang');
# 4th parameter (optionnal) : PERFORMANCE DATA TO BE SEND OR NOT
my $PERF_DATA= $plugin_nagios->opts->get('perf');

# ---- to be adaptated ---
# DEFAULT COUNTRY CODE
my $country_code_def="fr";
# program to launch to get informations
my $SENSORS='sensors';
# default value for sending performance data (0 : not send ; 1 : send)
my $perf_data_def = 1;
# -------------------------


if (!defined($PERF_DATA))
{
    #if not definied, set to true.
    $PERF_DATA = $perf_data_def;
}


# PATH FOR INI FILE (SAME AS THIS ONE)
my $PATH = `dirname $0`;
$PATH = substr($PATH, 0, -1);
if (substr($PATH,0,2) eq "./")
{
    $PATH=substr($PATH,2);
}

# BASE NAME FOR THE INI FILE
my $BASENAME = `basename $0`;
# suppress newline
$BASENAME = substr($BASENAME, 0, -1);
# supress extension (if exist)
if (index($BASENAME, '.') >= 0)
{
    # suppress last character until equal .
    while (substr($BASENAME,-1) ne '.') {
        $BASENAME = substr($BASENAME, 0, -1);
    }
    $BASENAME = substr($BASENAME,0, -1);
}


#if country_code parameter is null, default country_code is use
if (!defined($COUNTRY_CODE)) {$COUNTRY_CODE=''};
if ($COUNTRY_CODE eq '')
    {
    $COUNTRY_CODE=$country_code_def;
    }
# check if translation file exists
# if not, try to use default one

my $ini_file = "${PATH}/${BASENAME}_${COUNTRY_CODE}.ini";
if (!(-e $ini_file))
{
  # fichier traduc inexistant, lecture defaut
  $ini_file = "${PATH}/${BASENAME}.ini";
  if (!(-e $ini_file))
    {
    print "fatal error : conf file (${ini_file}) not found\n";
    exit(3);
    } 
}

#put content of the ini file in a memory array
my $hash_ref = Config::INI::Reader->read_file($ini_file);


# check sensors command available
my $dummy=`$SENSORS`;
if ($? == -1)
        {
        #print "\npgm sensors introuvable.\n";
        my $text01a=$hash_ref->{error}->{error01a};                
        my $text01b=$hash_ref->{error}->{error01b};                
        print "$text01a '$SENSORS' $text01b\n";
	exit(3);
        }

# function display help notice
sub dishelp() {
                 my $help01a=$hash_ref->{help}->{help01a};                
                 my $help01b=$hash_ref->{help}->{help01b};                
                 my $help02=$hash_ref->{help}->{help02};
                 print "$help01a \n$0 $help01b\n";
		 print " \n";
		 print "$help02\n";
		 exit(3);
}

# function trim for suppress leading spaces
sub trim {
    (my $s = $_[0]) =~ s/^\s+|\s+$//g;
    return $s;        
}

# check syntax
if (($PC eq "") || (int($NO) == 0))
    {
        &dishelp();
    }

#read PC configuration
my $NB=int($hash_ref->{$PC}->{NB});
$NO=int($NO);
if ($NO > $NB)
    {
    my $error02=$hash_ref->{error}->{error02};
    print "${error02}\n";
    exit(3);
    }

#read configuration

my $CPT="";
my $section_name = "${PC}_${NO}";
$CPT=$hash_ref->{$section_name}->{CPT};

my $LCP=' ';
my $UNI=' ';
my $MAXW=0;
my $MAXC=0;
my $MINW=0;
my $MINC=0;

$LCP=$hash_ref->{$section_name}->{LCP};
$UNI=$hash_ref->{$section_name}->{UNI};
$MAXW=$hash_ref->{$section_name}->{MAXW};
$MAXC=$hash_ref->{$section_name}->{MAXC};
$MINW=$hash_ref->{$section_name}->{MINW};
$MINC=$hash_ref->{$section_name}->{MINC};

my $CMD=`sensors | grep "$CPT"`;

#check if result is not a empty string
if ($CMD eq '')
    {
    my $error03=$hash_ref->{error}->{error03};
    print "${error03}\n";
    exit(3);
    }

# if sentence begining, DEB is length to cut
my $DEB=0;
$DEB=$hash_ref->{$section_name}->{DEB};
if (!(defined($DEB)))
    {
    $DEB=length($CPT);
    }
$DEB=$DEB+1;
$CMD = trim(substr $CMD,$DEB);

# extract numbers, sign and decimal point until space detected
my $idx=0;
my $CMD2='';
my $char='A';

while(($idx < length($CMD)) && ($char ne ' ') ) {
    $char=substr($CMD,$idx,1);
    if ((($char ge '0') && ($char le '9')) || ($char eq '+') || ($char eq '-') || ($char eq '.')) 
        {
        # copy to target string
        $CMD2=$CMD2.$char;
        #print "cmd2 = /${CMD2}/\n";
        }
    $idx++;
}

# number conversion
$CMD=$CMD2;

# si value begins by +, must delete it
my $STATS = '';
if ((substr $CMD,0,1) eq '+')
{
    $STATS = substr $CMD,1;
}
else
{
    $STATS=$CMD;
}


#read notification levels
my $NLW=$hash_ref->{notification_level}->{NLW};
my $NLC=$hash_ref->{notification_level}->{NLC};
my $NL0=$hash_ref->{notification_level}->{NL0};
my $NLI=$hash_ref->{notification_level}->{NLI};

# if MAXC is empty, it's just a information : no test to do
my $ind_info = 0;
my $line_output = '';

if (defined($MAXC))
    {
    if ($MAXC eq '')
        {
        $ind_info = 1;
        }
    }
else
    {
    $ind_info = 1;
    }

if ($ind_info == 1)
    {
    # output is just a infomation
    if ($PERF_DATA) {print "${LCP} ${CMD}${UNI} - ${NLI}|${LCP}=${STATS}\n";}
    else {print "${LCP} ${CMD}${UNI} - ${NLI}\n";}
    exit(0);
    }

# test max values (always)
if ($CMD > $MAXC)
    {
    # output is critical
    if ($PERF_DATA) {print "${LCP} ${CMD}${UNI} (${MAXC}${UNI}) - ${NLC}|'${LCP}'=${STATS};${MAXW};${MAXC}\n";}
    else {print "${LCP} ${CMD}${UNI} (${MAXC}${UNI}) - ${NLC}\n";}
    exit(2);
    }
if ($CMD > $MAXW)
    {
    # output is warning
    if ($PERF_DATA) {print "${LCP} ${CMD}${UNI} (${MAXW}${UNI}) - ${NLW}|'${LCP}'=${STATS};${MAXW};${MAXC}\n";}
    else {print "${LCP} ${CMD}${UNI} (${MAXW}${UNI}) - ${NLW}\n";} 
    exit(1);
    }

# test minus values (if exists)

if (defined($MINC) && defined($MINW))
{
    if (($MINC != 0) || ($MINW != 0))
    {
        if ($CMD < $MINW)
        {
         #output is warning   
         if ($PERF_DATA) {print "${LCP} ${CMD}${UNI} (${MINW}${UNI}) - ${NLW}|'${LCP}'=${STATS};${MINW};${MAXC}\n";}
         else {print "${LCP} ${CMD}${UNI} (${MINW}${UNI}) - ${NLW}";}
            exit(1);
        }
        if ($CMD < $MINC)
        {
         # output is critical  
         if ($PERF_DATA) {print "${LCP} ${CMD}${UNI} (${MINC}${UNI}) - ${NLC}|'${LCP}'=${STATS};${MINW};${MAXC}\n";}
            else {print "${LCP} ${CMD}${UNI} (${MINC}${UNI}) - ${NLC}\n";}
            exit(2);
        }
    }
}

# output with ok status
if ($PERF_DATA)
    {
    print "${LCP} ${CMD}${UNI} - ${NL0}|'${LCP}'=${STATS};${MAXW};${MAXC}";
    }
    else
    {
    print "${LCP} ${CMD}${UNI} - ${NL0}";
    }
exit 0;

