#!/bin/bash
#
# TL-ER5120 CPU Usage Plugin

PROGNAME=`basename $0`
PROGPATH=`dirname $0`
VERSION="Version 1.0,"
AUTHOR="2012, Rascal (http://rascal.su/)"

warning=80
critical=90

. $PROGPATH/utils.sh

# Option processing
print_usage() {
  echo "Usage: $PROGNAME -H <ADDRESS> -u <LOGIN> -p <PASSWORD> -w <WARNING> -c <CRITICAL>"
  echo "  $PROGNAME -h"
  echo "  $PROGNAME -v"
}

print_version() {
    echo "$VERSION $AUTHOR"
}

check_arg() {
    # make sure you supplied all arguments
    if [ -z "$hostname" ]  || [ -z "$username" ] || [ -z "$password" ]; then
        print_usage
        exit $OK
    fi
}

get_wcdiff() {
    if [ ! -z "$warning" -a ! -z "$critical" ]
    then
        wclvls=1

        if [ ${warning} -ge ${critical} ]
        then
            wcdiff=1
        fi
    elif [ ! -z "$warning" -a -z "$critical" ]
    then
        wcdiff=2
    elif [ -z "$warning" -a ! -z "$critical" ]
    then
        wcdiff=3
    fi
}

val_wcdiff() {
    if [ "$wcdiff" = 1 ]
    then
        echo "Please adjust your warning/critical thresholds. The warning \
must be lower than the critical level!"
        exit $STATE_UNKNOWN
    elif [ "$wcdiff" = 2 ]
    then
        echo "Please also set a critical value when you want to use \
warning/critical thresholds!"
        exit $STATE_UNKNOWN
    elif [ "$wcdiff" = 3 ]
    then
        echo "Please also set a warning value when you want to use \
warning/critical thresholds!"
        exit $STATE_UNKNOWN
    fi
}

get_status() {
    output=`$PROGPATH/check_er5120_cpu.expect $hostname $username $password 2>&1 |grep CPU |sed 's/\r//'| sed 's/Press any key to continue (Q to quit)//'`
}

get_vals() {
    cpu_usage=`echo $output |cut -d ' ' -f 4 |cut -d '%' -f 1`
}

do_perfdata() {
    perfdata="cpu_used=$cpu_usage;$warning;$critical;0"
}

while test -n "$1"; do
    case "$1" in
        -h)
            print_usage
            exit $STATE_UNKNOWN
            ;;
        -v)
            print_version $PROGNAME $VERSION
            exit $STATE_UNKNOWN
            ;;
        -H)
            hostname=$2
            shift
            ;;
        -u)
            username=$2
            shift
            ;;
        -p)
            password=$2
            shift
            ;;
        -w)
            warning=$2
            shift
            ;;
        -c)
            critical=$2
            shift
            ;;
        *)
            echo "Unknown argument: $1"
            print_usage
            exit $STATE_UNKNOWN
            ;;
        esac
    shift
done

# Let's Go
check_arg
get_wcdiff
val_wcdiff
get_status
get_vals
do_perfdata

if [ -n "$warning" -a -n "$critical" ]
then
    if [ "$cpu_usage" -ge "$warning" -a "$cpu_usage" -lt "$critical" ]
    then
        echo "WARNING - ${output} | ${perfdata}"
        exit $STATE_WARNING
    elif [ "$cpu_usage" -ge "$critical" ]
    then
        echo "CRITICAL - ${output} | ${perfdata}"
        exit $STATE_CRITICAL
    else
        echo "OK - ${output} | ${perfdata}"
        exit $STATE_OK
    fi
else
    echo "OK - ${output} | ${perfdata}"
    exit $STATE_OK
fi
