#!/usr/bin/perl
# nagios: -epn
## $Id: check_nextreboot by J.Ph. LEMOINE$

## Nagios Plugin for knowing if a disk will be check at next boot

##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
use warnings;
use Switch;
use Config::INI::Reader;
use Nagios::Plugin;
use vars qw/ $VERSION /;
use lib "/usr/lib/perl5/B";

#put here the file to check
my $filetocheck = "/var/lib/update-notifier/fsck-at-reboot";

$VERSION = '1.0';
my $LICENCE = "Ce plugin Nagios est gratuit et libre de droits, et vous pouvez l'utiliser à votre convenance."
  . ' Il est livré avec ABSOLUMENT AUCUNE GARANTIE.';

my $plugin_nagios = Nagios::Plugin->new(
  shortname => 'check nextreboot',
  usage     => 'Usage : %s ',
  version   => $VERSION,
  license   => $LICENCE,
);

# put the real file to check

# put the 2 letters of the country code
# in 02/27/2013, there is 2 possibilies :
# fr for french
# en for english
my $country_code_def="fr";

# variables declaration
my $APCA_ARGS="status";

#$plugin_nagios->add_arg(
#  spec     => 'action|a=s',
#  help     => '<load|bcharge|time|status>',    # Aide au sujet de cette option
#  required => 1,                  # Argument obligatoire
#);

$plugin_nagios->add_arg(
spec     => 'lang|l=s',
help     => 'fr or en',    # Aide au sujet de cette option
required => 0              # Argument facultatif
);

$plugin_nagios->add_arg(
spec     => 'dishelp|d',
help     => 'detailled help',    # Aide au sujet de cette option
required => 0              # Argument facultatif
);


$plugin_nagios->getopts();


my $COUNTRY_CODE = $plugin_nagios->opts->get('lang');
my $HELP_WANTED  = $plugin_nagios->opts->get('dishelp');

sub display_usage()
    {
    print "Usage : check_apcupsd.new.pl [-l|--lang fr|en] [-d|--dishelp]\n";
    print "\n";
    print "Missing argument: $_[0]\n";
    }

# ---- fin recup parametre

# check if translation file exists
# if not, try to use default one

my $PROGNAME=`basename $0`;
chomp($PROGNAME);
my $NAME_INI=substr $PROGNAME, 0, -3;


if (!(defined($COUNTRY_CODE)))
    {
    $COUNTRY_CODE = $country_code_def;
    }

my $ini_file = "${NAME_INI}_${COUNTRY_CODE}.ini";

if (!(-e $ini_file))
{
  # fichier traduc inexistant, lecture defaut
  $ini_file = "${NAME_INI}.ini";
  if (!(-e $ini_file))
    {
    print "fatal error : conf file (${ini_file}) not found";
    exit 3;
    } 
}


#put translations in memory
my $hash_ref = Config::INI::Reader->read_file($ini_file);
# display help notice
sub dishelp() {
                 my $help01a=$hash_ref->{help}->{help01a};                
                 my $help01b=$hash_ref->{help}->{help01b};                
                 my $help01c=$hash_ref->{help}->{help01c};                
                 my $help02=$hash_ref->{help}->{help02};
                 my $help03=$hash_ref->{help}->{help03};
                 #my $help04=$hash_ref->{help}->{help04};
                 #my $help05=$hash_ref->{help}->{help05};
                 #my $help06=$hash_ref->{help}->{help06};
                 print "$help01a \n$0 $help01b\n";
                 print "$0 $help01c\n";
		 print " \n";
		 print "$help02\n";
		 print "$help03\n";
		 #print "$help04\n";
		 #print "$help05\n";
		 #print " \n";
		 #print "$help06\n";
		 exit 3;
}

# test if file to test is available
if (!(-e $filetocheck))
{
       my $text01a=$hash_ref->{error}->{error01a};                
        my $text01b=$hash_ref->{error}->{error01b};                
        print "$text01a '$filetocheck' $text01b\n";
	exit 3;
}




my $APCA="cat ${filetocheck}";


my $result=`$APCA`;

# function trim for suppress leadind spaces
sub trim {
    (my $s = $_[0]) =~ s/^\s+|\s+$//g;
    return $s;        
}

# main test
if (!defined($HELP_WANTED))
{
    # help not wanted : normal check
    if ($result eq '')
    {
        #No disk control at next reboot
        my $msgNo=$hash_ref->{msg}->{msgNo};
        print $msgNo;
        # status ok
        exit 0;
    }
    else
    {
        # at least one disk is listed
        $result = trim($result);
        # retrive the disk drive 
        # remove the string ***
        $result=substr $result, 4;
        my $idx = index($result, ' ');
        # /dev/xxx
        $result=trim(substr $result,1,$idx);
        # xxx
        $result=trim(substr $result,4);     

        #display message 
        my $msgYes01=$hash_ref->{msg}->{msgYes01};
        my $msgYes02=$hash_ref->{msg}->{msgYes02};      
        print "${msgYes01}${result}${msgYes02}";
        # status warning
        exit 1;
    }
}
else
{
    # help is wanted
    &dishelp;
    exit 3;
}

