#!/bin/bash
#check_time v 0.1.3 [code name: Saoco]
#made by Fabio Pardi 2013, pachistano@gmail.com
#ChangeLog: some spring clean + a new feature: now is possible to specify a port to connect to. using "-P" flag. Thanks to Toni Stjepanovic
#Enjoy the spring, if you have one in your country!

#variables definition 
work_dir=/usr/local/nagios/libexec/
awk=/usr/bin/awk

host=0
warning=a
critical=a
port=22
user=noroot

exit_code=0
##################################################
#############################################
print_help() {
        echo ""
        echo "Usage: $PROGNAME --help"
 	echo "Usage: $PROGNAME -H host -P port -u user -w warning -c critical "
        echo ""
        echo "Plugin to check time difference between this host and the target host"
	echo ""
	echo "PARAMETERS:"
	echo "-> host: is the host to be checked - hostname or IP (best practice is IP)"
        echo "-> user is the user we are using to connect, on the remote server"
	echo "-> warning is the difference threshold in seconds"
	echo "-> critical is the difference threshold in seconds"
	echo "NOTE: you must exchange SSH key between the user running nagios no this host (usually user is called nagios) and the target machine"
        echo ""
}
##################################################
##############################################
#parameters check
while test -n "$1"; do
   case "$1" in
        --help)
            print_help
            exit 2
            ;;

        -H)
            host=$2
            shift
            ;;
	-w)
            warning=$2
            shift
            ;;
        -c)
            critical=$2
            shift
            ;;
        -u)
            user=$2
            shift
            ;;
        -P)
            port=$2
            shift
           ;;
        *)
            echo "Unknown argument: $1"
            print_help
            exit 2
            ;;
    esac
    shift
done 


if  [[ "$host" == "0" || $user == "noroot" || $warning == "a"   ||  $critical == "a"  ]]
then
	echo parameters not set!
	print_help
	exit
fi

if [ $warning -ge $critical ]
then
	echo "warning threshold cannot be equal or bigger than critical"
	exit
fi

remote=`ssh -p $port $user@$host "date +%s"`

[ -z "$remote" ] && echo "ssh time check failed." && exit 1;

local=`date +%s`
diff=`expr $remote - $local`
#normalize number, in case it is negative
diff=${diff/-/}


if [ $diff -gt $critical ]
then
	echo "Difference is $diff seconds"
	exit 2
fi

if [ $diff -gt $warning  ]
then
	echo "Difference is $diff seconds"
	exit 1
fi

#if we reach this point, it means everything worked out
echo "OK, we are on time!"
exit 0

		#NAGIOSEXIT
		#exit codes (service status)
		#0=OK
		#1=warning
		#2=critical
