program check_mssql_nt;{$APPTYPE CONSOLE}

{

This program is free software; you can redistribute it and/or modify it under the GNU General Public License.
Written by Francois Zbinden (zbinden@dataflow.ch), 2008

}

uses
  SysUtils,
  CommCtrl,
  Messages,
  Windows,
  DateUtils,
  ActiveX,
  uDMMSSqlCheck in 'uDMMSSqlCheck.pas' {DMNagiosClient: TDataModule};

var
  aStatusStr, outPerfStr: string;

const
  USAGELINE =
    'Usage: check_mssql_nt.exe [/h] /H:hostname [/D:dbname] [/U:username] [/P:password] [/t:timeout] [/CHK_CONNECT] [/CHK_CONNECTIONCOUNT] [/CHK_QUERY:ownquery] /w:warn_secs '+
    ' /c:crit_secs /Wv:[max_value|min_value:max_value] /Cv:[max_value|min_value:max_value] [/PF:outformatter]';
  VERSION = '0.1';

  function GetCmdLineSwitch(const ASwitch: string; const IgnoreCase: boolean = True): boolean;
  begin
    Result := FindCmdLineSwitch(ASwitch, ['-', '/'], IgnoreCase);
  end;

  function GetCmdLineSwitchValue(out AValue: string; const ASwitch: string;
  const IgnoreCase: boolean = True): boolean;
  const
    CompareFunction: array[boolean] of function(const s1, s2: string): integer =
      (CompareStr, CompareText);
  var
    iCmdLine, iSplit: integer;
    s, sName, sValue: string;
  begin
    Result := False;

    for iCmdLine := 1 to ParamCount do
    begin
      s := ParamStr(iCmdLine);

      if not (s[1] in ['-', '/']) then
        Continue;

      Delete(s, 1, 1);
      iSplit := Pos(':', s);
      if iSplit = 0 then
        iSplit := Pos('=', s);

      if iSplit = 0 then
        Continue;

      sName  := Copy(s, 1, iSplit - 1);
      sValue := Copy(s, iSplit + 1, length(s));

      if CompareFunction[IgnoreCase](ASwitch, sName) = 0 then
      begin
        AValue := sValue;
        Result := True;
        Break;
      end;
    end;
  end;

  procedure ShowHelp;
  begin
    Writeln('MSSQL Server Nagios Check Plugin by Francois Zbinden (zbinden@dataflow.ch)');
    WriteLn(' ');
    WriteLn(USAGELINE);
  //  WriteLn('Examples:');
  {   WriteLn('Check connectivity: check_mssql_nt /H:sqlv1');
     WriteLn('Check connectivity with time check (warn >0.1s, critical >2s): check_mssql_nt /H:sqlv1 -w:0.1 -c:2');
     WriteLn('Check connections count: check_mssql_nt /H:sqlv1 /Q:TOTAL_CONNECTION_COUNT -w:0.1:10 -c:2');  }
  end;

  function GetTimeSwitch(sN: string): double;
  var
    tmp: string;
  begin
    result:=0;
    if GetCmdLineSwitchValue(tmp, sn) then
    begin
      try
        Result := StrToFloat(tmp)
      except
        raise Exception.Create('Wrong time value');
      end;
    end else
    if GetCmdLineSwitch(sn) then
      raise Exception.Create('Missing time value');

  end;


  procedure GetValueSwitch(sN: string; var oMin, oMax: integer);
  var
    tmp: string;
  begin
    if GetCmdLineSwitchValue(tmp, sn) then
    begin
      try
        if pos(':',tmp)>0 then
        begin
             writeln(copy(tmp,pos(':',tmp)+1,length(tmp)));
          oMin:=strToInt(copy(tmp,0,pos(':',tmp)-1));
          oMax:=strToInt(copy(tmp,pos(':',tmp)+1,length(tmp)));
        end else
        begin
          oMin:=-1;
          oMax:=strtoint(tmp);
        end;
      except
        raise Exception.Create('Wrong value');
      end;
      if oMin>oMax then
        raise Exception.create('Minimun value bigger than maximum value');
    end else
    if GetCmdLineSwitch(sn) then
      raise Exception.Create('Missing value');

  end;


  function CheckMSSQL: integer;
  var
    MSSQLClient:  TDMNagiosClient;
    parHostName, parDBName, parUsername, parPassword, parType, parOwnQuery, parTmp: string;
    parQueryType: TQueryType;
    parWarnTime, parCriticalTime: double;
    parWarnValueMin, parWarnValueMax, parCriticalValueMin, parCriticalValueMax,parTimeout: integer;
    parQueryValuePrettyFormat:string;
  begin
    outPerfStr := '';
    CoInitializeEx(nil, 0);
    MSSQLClient  := TDMNagiosClient.Create(nil);
    parQueryType := qtConnect;
    parWarnTime  := 0;
    parCriticalTime := 0;
    parWarnValueMin := -1;
    parWarnValueMax := -1;
    parCriticalValueMin := -1;
    parCriticalValueMax := -1;
    parQueryValuePrettyFormat:='';
    try

      try
        if not GetCmdLineSwitchValue(parHostName, 'H', False) then
          raise Exception.Create('Missing hostname parameter');

        GetCmdLineSwitchValue(parDBName, 'D');
        GetCmdLineSwitchValue(parUsername, 'U');
        GetCmdLineSwitchValue(parPassword, 'P');

        if GetCmdLineSwitch('CHK_CONNECTIONCOUNT') then
          parQueryType := qtConnectionCount;


        if GetCmdLineSwitchValue(parOwnQuery, 'CHK_QUERY') then
        begin
          parQueryType := qtOwnQuery;
        end else if GetCmdLineSwitch('CHK_QUERY') then
          raise Exception.Create('missing query string');

        parWarnTime := GetTimeSwitch('W');
        parCriticalTime := GetTimeSwitch('C');

        GetValueSwitch('Wv',parWarnValueMin,parWarnValueMax);
        GetValueSwitch('Cv',parCriticalValueMin,parCriticalValueMax);

        parTimeout := round( GetTimeSwitch('T'));

         if not GetCmdLineSwitchValue(parQueryValuePrettyFormat, 'FO') then
           if GetCmdLineSwitch('FO') then
             raise Exception.Create('missing pretty format string');

      except
        on e: Exception do
          raise Exception.Create(e.message + #13#10 + USAGELINE);
      end;

      try

        with MSSQLClient do
        begin

          Hostname  := parHostName;
          Username  := parUsername;
          Password  := parPassword;
          Database  := parDBName;
          querytype := parQueryType;
          OwnQueryStr := parOwnQuery;
          WarnTime  := parWarnTime;
          CriticalTime := parCriticalTime;
          WarnValueMin := parWarnValueMin;
          WarnValueMax := parWarnValueMax;
          CriticalValueMin := parCriticalValueMin;
          CriticalValueMax := parCriticalValueMax;
          QueryValuePrettyFormat:=parQueryValuePrettyFormat;
          timeout:=parTimeout;


          Result := MSSQLClient.Check;

          aStatusStr := MSSQLClient.StatusStr;
          outPerfStr := MSSQLClient.PerfStr;
        end;
      except
        on e: Exception do
        begin
          Result := 2;
          aStatusStr := e.message;
        end;
      end;

    finally
      MSSQLClient.Free;
      CoUninitialize;

    end;

  end;

var
  res: integer;
  StatusType: string;
begin
  if GetCmdLineSwitch('h', False) or GetCmdLineSwitch('?', False) then
  begin
    ShowHelp;
    Halt(3);
  end;

  aStatusStr := '';
  try
    res := CheckMSSQL;
  except
    on e: Exception do
    begin
      aStatusStr := e.message;
      res := 3;
    end;
  end;
  case res of
    0: StatusType := 'OK';
    1: StatusType := 'WARNING';
    2: StatusType := 'CRITICAL';
    3: StatusType := 'UNKNOWN';
  end;
  Writeln(format('MSSQL %s - %s%s', [StatusType, aStatusStr, outPerfStr]));
  Halt(res);
end.
