unit uDMMSSqlCheck;

interface

uses
  SysUtils, Classes, DB, ADODB, ACtiveX, DateUtils;

type

  TQueryType = (qtConnect, qtConnectionCount, qtOwnQuery);


  TDMNagiosClient = class(TDataModule)
    ADOConnection: TADOConnection;
    ADOQuery:      TADOQuery;
    procedure DataModuleCreate(Sender: TObject);
  private
    FStatusStr:    string;
    FCriticalTime: double;
    FWarnTime:     double;
    FPerfStr:      string;
    FHostname:     string;

    FDatabase:         string;
    FPassword:         string;
    FUsername:         string;
    FWarnValueMin:     integer;
    FWarnValueMax:     integer;
    FCriticalValueMax: integer;
    FCriticalValueMin: integer;
    FQueryType:        TQueryType;
    FOwnQueryStr:      string;
    FQueryValuePrettyFormat: string;
    FTimeout: integer;
    procedure SetStatusStr(const Value: string);
    procedure SetPerfStr(const Value: string);
    procedure SetHostname(const Value: string);

    procedure SetOwnQueryStr(const Value: string);
    procedure ConnectDB;
    function DoQuery: integer;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    function Check: integer;

    property Hostname: string Read FHostname Write SetHostname;
    property Database: string Read FDatabase Write FDatabase;
    property Username: string Read FUsername Write FUsername;
    property Password: string Read FPassword Write FPassword;

    property Timeout:integer read FTimeout write FTimeout;
    property StatusStr: string Read FStatusStr Write SetStatusStr;
    property PerfStr: string Read FPerfStr Write SetPerfStr;

    property WarnTime: double Read FWarnTime Write FWarnTime;
    property CriticalTime: double Read FCriticalTime Write FCriticalTime;

    property WarnValueMin: integer Read FWarnValueMin Write FWarnValueMin;
    property WarnValueMax: integer Read FWarnValueMax Write FWarnValueMax;
    property CriticalValueMin: integer Read FCriticalValueMin Write FCriticalValueMin;
    property CriticalValueMax: integer Read FCriticalValueMax Write FCriticalValueMax;

    property QueryType: TQueryType Read FQueryType Write FQueryType;
    property OwnQueryStr: string Read FOwnQueryStr Write SetOwnQueryStr;

    property QueryValuePrettyFormat: string read FQueryValuePrettyFormat write FQueryValuePrettyFormat;
  end;


implementation



{$R *.dfm}

{ TDMNagiosClient }

procedure TDMNagiosClient.DataModuleCreate(Sender: TObject);
begin
  FWarnTime := 0;
  FCriticalTime := 0;
  FPerfStr  := '';
  FQueryType := qtConnect;
  FWarnValueMin := -1;
  FWarnValueMax := -1;
  CriticalValueMin := -1;
  CriticalValueMax := -1;
  FTimeOut:=30;
end;

procedure TDMNagiosClient.SetHostname(const Value: string);
begin
  FHostname := Value;
end;

procedure TDMNagiosClient.SetOwnQueryStr(const Value: string);
begin
  FOwnQueryStr := Value;
end;

procedure TDMNagiosClient.SetPerfStr(const Value: string);
begin
  FPerfStr := Value;
end;

procedure TDMNagiosClient.SetStatusStr(const Value: string);
begin
  FStatusStr := Value;
end;



function TDMNagiosClient.Check: integer;
var
  aConnectionString: string;
  StartAt:  TDateTime;
var
  Duration: double;
begin

  try
    try
      StartAt  := now;
      FStatusStr := '';
      FPerfStr := '';
      result:=0;

      ConnectDB;

     try
      if FQueryType <> qtConnect then
      begin
        Result := DoQuery;
      end;

     finally
       ADOConnection.Close;
     end;

      Duration := SecondSpan(now, StartAt);

      if (CriticalTime > 0) and (Duration >= CriticalTime) then
        Result := 2
      else if (WarnTime > 0) and (Duration >= WarnTime) then
        Result := 1;

      if FQueryType = qtConnect then
        FStatusStr := format('connected, %.2f seconds', [Duration])
     else if QueryValuePrettyFormat='' then
        FStatusStr := format('%s in %.2f seconds', [FStatusStr, Duration]);

      FPerfStr := FPerfStr+ format('|time=%4.5fs;%4.5f;%4.5f;%4.5f;%4.5f', [Duration, WarnTime,
        CriticalTime, 0.0, 0.0]);

    except
      on e: Exception do
      begin
        FStatusStr := 'Error: ' + e.message;
        Result := 2;
      end;
    end;
  finally

  end;
end;

function TDMNagiosClient.DoQuery: integer;
var
  aval: integer;
  WarnStr,
  CritStr:string;
begin
  Result := 0;

  with ADOQuery do
  begin
    if QueryType = qtConnectionCount then
    begin
      SQL.Text := 'select count(dbid) as connections from sys.sysprocesses';
      if Database <> '' then
        SQL.Text := SQL.Text + format(' where db_name(dbid)=%s', [QuotedStr(Database)]);
    end else
      sql.Text := OwnQueryStr;

    Open;

    if QueryType = qtConnectionCount then
    begin
      FStatusStr := format('%d connections', [fields[0].AsInteger]);
      aval:= fields[0].AsInteger;
    end else
    begin

       if adoquery.RecordCount = 0 then
        raise Exception.create('query returns 0 records');
       if adoquery.RecordCount > 1 then
        raise Exception.create('query returns more than 1 record');

        try
          aval := adoquery.Fields[0].AsInteger;
          if QueryValuePrettyFormat<>'' then
              FStatusStr := format(QueryValuePrettyFormat, [aval])
            else
          FStatusStr := format('query value="%d"', [aval]);

          if (WarnValueMin >=0) and (aval<=WarnValueMin) then
            result:=1;
          if (WarnValueMax >=0) and (aval>=WarnValueMax) then
            result:=1;

          if (CriticalValueMin >=0) and (aval<=CriticalValueMin) then
            result:=2;
          if (CriticalValueMax >=0) and (aval>=CriticalValueMax) then
            result:=2;


        except
          raise Exception.Create('first field of result is not integer value');
        end;

    end;
   warnstr:='';
   if WarnValueMax>=0 then
     warnstr:=inttostr(WarnValueMax);
   if (WarnValueMin >=0) then
     warnstr:=inttostr(WarnValueMin)+':'+warnstr;
  CritStr:='';
   if CriticalValueMax>=0 then
     CritStr:=inttostr(CriticalValueMax);
   if (CriticalValueMin >=0) then
    CritStr:=inttostr(CriticalValueMin)+':'+CritStr;

   FPerfStr := format('|query=%d;%s;%s;%d;%d', [AVAL, warnstr,
        CritStr, 0, 0]);
  end;

end;

procedure TDMNagiosClient.ConnectDB;
var
  aConnectionString: string;
begin

  aConnectionString := 'Provider=SQLNCLI.1;';
  aConnectionString := aConnectionString + format(';Server=%s', [hostname]);
  if FDatabase <> '' then
    aConnectionString := aConnectionString + format(';database=%s', [FDatabase]);
  if FUsername <> '' then
    aConnectionString := aConnectionString + format(';User ID=%s;Password=%s',
      [FUsername, FPassword])
  else
      aConnectionString:=aConnectionString + ';Integrated Security=SSPI';

   { aConnectionString := aConnectionString + format(';Connect Timeout=%d',
      [FTimeOut]); }
      Timeout:=2;
   ADOConnection.ConnectionTimeout:=Timeout;
  ADOConnection.ConnectionString := aConnectionString;
  ADOConnection.CommandTimeout:=Timeout;
  ADOConnection.Open;
end;

end.
