<?

/* --------------------------------------------------------------
      include common settings
   -------------------------------------------------------------- */
require_once("common.inc.php");

/* --------------------------------------------------------------
      connect to the database
   -------------------------------------------------------------- */
require_once("db_connect.inc.php");

/* --------------------------------------------------------------
      write the services file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."services.cfg";
$handle = fopen($path,"w");
    
    $servicesConfig="
define service{
        name                            generic-service
        active_checks_enabled           1   
        passive_checks_enabled          1   
        parallelize_check               1   
        obsess_over_service             1   
        check_freshness                 1   
        freshness_threshold             60  
        notifications_enabled           1   
        event_handler_enabled           1   
        flap_detection_enabled          1   
        process_perf_data               1   
        retain_status_information       1   
        retain_nonstatus_information    1   
        register                        0   
        }
";

/*
$getServiceConfigQuery = "SELECT `id`, `use`, `host_name`, `service_description`, `is_volatile`, `check_period`,
				`max_check_attempts`, `normal_check_interval`, `retry_check_interval`, `check_freshness`,
				`freshness_threshold`, `contact_groups`, `notification_interval`, `notification_period`,
				`notification_options`, `check_command`, `arg1_value`, `arg2_value`, `arg3_value`, `arg4_value`, `arg5_value` 
				FROM `services`";

$getServiceConfigQuery = "SELECT s.id, s.use, h.host_name, s.service_description, s.is_volatile, t.timeperiod_name,
				 s.max_check_attempts, s.normal_check_interval, s.retry_check_interval, s.check_freshness,
				 s.freshness_threshold, cg.contactgroup_name, s.notification_interval, s.notification_period,
				 s.notification_options, cc.command_name, s.arg1_value, s.arg2_value, s.arg3_value, s.arg4_value,
				 s.arg5_value FROM services s left join hosts h on s.host_name=h.id left join timeperiods t on s.check_period=t.id
			 	 left join contactgroups2services cg2s on s.id=services_id left join contactgroups cg on cg2s.contactgroups_id=cg.id
				 left join timeperiods on s.notification_period=t.id left join checkcommands cc on s.check_command=cc.id";
*/
$getServiceConfigQuery = "SELECT s.id, s.use, h.host_name, s.service_description, s.is_volatile, t.timeperiod_name as check_period, 
                                  s.max_check_attempts, s.normal_check_interval, s.retry_check_interval,
                                  s.check_freshness, s.freshness_threshold, cg.contactgroup_name, s.notification_interval,
                                  t.timeperiod_name as notification_period, s.notification_options, cc.command_name, 
                                  s.arg1_value, s.arg2_value, 
                                  s.arg3_value, s.arg4_value, s.arg5_value
                          FROM services s 
                                  left join hosts2services h2s on h2s.services_id=s.id
                                  left join hosts h on h.id=h2s.hosts_id
                                  left join timeperiods t on s.check_period=t.id 
                                  left join contactgroups2services cg2s on cg2s.services_id=s.id
                                  left join contactgroups cg on cg2s.contactgroups_id=cg.id
                                  left join checkcommands cc on s.check_command=cc.id
                          ORDER BY h.host_name";
$getServiceConfigResult = mysql_query($getServiceConfigQuery);

for($serviceCount=0; $serviceRow=mysql_fetch_row($getServiceConfigResult); $serviceCount++) {
		list($id, $use, $host_name, $service_description, $is_volatile, $check_period, $max_check_attempts, $normal_check_interval, $retry_check_interval, $check_freshness, $freshness_threshold, $contact_groups, $notification_interval, $notification_period, $notification_options, $check_command, $arg1, $arg2, $arg3, $arg4, $arg5) = $serviceRow;

$use = get_value_from_id("hoststemplate", "name", $use);
// $host_name = get_value_from_id("hosts", "host_name", $host_name);
// $check_period = get_value_from_id("timeperiods", "timeperiod_name", $check_period);
// $contact_groups = get_value_from_id("contactgroups", "contactgroup_name", $contact_groups);
// $notification_period = get_value_from_id("timeperiods", "timeperiod_name", $notification_period);
// $check_command = get_value_from_id("checkcommands", "command_name", $check_command);

$servicesConfig.="
define service{
	use				generic-service
	host_name			$host_name
	service_description		$service_description
	is_volatile			$is_volatile
	check_period			$check_period
	max_check_attempts		$max_check_attempts
	normal_check_interval		$normal_check_interval
	retry_check_interval		$retry_check_interval
	check_freshness			$check_freshness
	freshness_threshold		$freshness_threshold
	contact_groups			$contact_groups
	notification_interval		$notification_interval
	notification_period		$notification_period
	notification_options		$notification_options
	check_command			$check_command";
if($arg1 !== "") $servicesConfig.="!$arg1";
if($arg2 !== "") $servicesConfig.="!$arg2";
if($arg3 !== "") $servicesConfig.="!$arg3";
if($arg4 !== "") $servicesConfig.="!$arg4";
if($arg5 !== "") $servicesConfig.="!$arg5";
$servicesConfig.="
	}
";
				}
fwrite($handle,$servicesConfig);
fclose($handle);

/* --------------------------------------------------------------
      write the checkcommands.cfg file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."checkcommands.cfg";
$handle = fopen($path,"w");

    $config="
################################################################################
# COMMAND DEFINITIONS
#
# SYNTAX:
#
#       define command{
#               template      <templatename>
#               name          <objectname>
#               command_name  <commandname>
#               command_line  <commandline>
#               }
#
# WHERE:
#
# <templatename> = object name of another command definition that should be
#                  used as a template for this definition (optional)
# <objectname>   = object name of command definition, referenced by other
#                  command definitions that use it as a template (optional)
# <commandname>  = name of the command, as recognized/used by Nagios
# <commandline>  = command line
#
################################################################################
";
$configQuery="SELECT `command_name`, `command_line` FROM `checkcommands` ORDER BY `command_name`";
$configResult = mysql_query($configQuery);
for($configCount=0; $configRow=mysql_fetch_row($configResult); $configCount++) {

list($command_name, $command_line) = $configRow;

$config.="
# '$command_name' command definition
define command{
	command_name	$command_name
	command_line	$command_line
}
";
}
fwrite($handle,$config);
fclose($handle);

/* --------------------------------------------------------------
      write the contactgroups.cfg file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."contactgroups.cfg";
$handle = fopen($path,"w");

unset($config);
$configQuery="SELECT `id`, `contactgroup_name`, `alias` FROM `contactgroups` ORDER BY `contactgroup_name`";
$configResult=mysql_query($configQuery);

for($configCount=0; $configRow=mysql_fetch_row($configResult); $configCount++) {
	list($id, $contactgroup_name, $alias)=$configRow;
//	echo $contactgroup_name."<BR>";

	// loop through contacts2contactgroups.contactsId
	$contactsIdQuery = sprintf("SELECT contactsId FROM contacts2contactgroups WHERE contactgroupsId=%s", quote_smart($id));
	$contactsIdResult = mysql_query($contactsIdQuery);
	$contactsIdNumRows = mysql_num_rows($contactsIdResult);
	unset($members);	
	for($contactsIdCount=0; $contactsIdRow=mysql_fetch_row($contactsIdResult); $contactsIdCount++) {
		list($contactsId)=$contactsIdRow;
//		echo $contactsId."<BR>";

		// get contacts.contact_name WHERE id is $contactsId
		$contact_nameQuery = sprintf("SELECT contact_name FROM contacts WHERE id=%s", quote_smart($contactsId));
		$contact_nameResult = mysql_query($contact_nameQuery);
		$contact_nameNumRows = mysql_num_rows($contact_nameResult);
		for($contact_nameCount=0; $contact_nameRow=mysql_fetch_row($contact_nameResult); $contact_nameCount++) {
			list($contact_name)=$contact_nameRow;
			$members.=$contact_name;
			if( ($contactsIdCount < ($contactsIdNumRows-1))) {
				$members.=", ";
			}
//			echo "$contactsIdCount ------- $contactsIdNumRows <BR>";
		}
	}
                $config.="
define contactgroup{
        contactgroup_name       $contactgroup_name
        alias                   $alias
        members                 $members
        }
";
//              echo $config;

//	echo "<BR>";

}

/*
	$config.="
	define contactgroup{
		contactgroup_name       $contactgroup_name
		alias                   $alias
		members                 $members
		}
	";
*/
fwrite($handle,$config);
fclose($handle);

/* --------------------------------------------------------------
      write the contacts.cfg file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."contacts.cfg";
$handle = fopen($path,"w");

unset($config);
/*
$configQuery = "SELECT `contact_name`, `alias`, `service_notification_period`, `host_notification_period`, 
			`service_notification_options`, `host_notification_options`, `service_notification_commands`,
			`host_notification_commands`, `email`, `pager` FROM `contacts` ORDER BY `contact_name`";
*/
/*
$configQuery = "SELECT c.contact_name, c.alias, t.timeperiod_name as service_notification_period,
                        t.timeperiod_name as host_notification_period, c.service_notification_options,
                        c.host_notification_options, m.command_name as service_notification_commands,
                        m.command_name as host_notification_commands, c.email, c.pager
                FROM contacts c
                        left join timeperiods t on c.service_notification_period=t.id
                        left join servicecommands2contacts sc2c on sc2c.contacts_id=c.id
                        left join misccommands m on m.id=sc2c.servicecommands_id
                        left join hostcommands2contacts hc2c on hc2c.contacts_id=c.id
                        left join misccommands on m.id=hc2c.hostcommands_id
                ORDER BY c.contact_name";
*/
// loop through contacts
$contactsQuery = "SELECT id FROM contacts";
$contactsResult = mysql_query($contactsQuery);
for($contactCount=0; $contactRow=mysql_fetch_row($contactsResult); $contactCount++) {
  list($contactId) = $contactRow;
    
  // get host notification commands for contact
  $h2cQuery = "SELECT hostcommands_id FROM hostcommands2contacts WHERE contacts_id='$contactId'";
  $h2cResult = mysql_query($h2cQuery);
  unset($hostCommands);
  for($h2cCount=0; $h2cRow=mysql_fetch_row($h2cResult); $h2cCount++) {
    list($h2cId) = $h2cRow;
    $hostCommands[] = $h2cId;
  }
  
  // get service notification commands for contact
  $s2cQuery = "SELECT servicecommands_id FROM servicecommands2contacts WHERE contacts_id='$contactId'";
  $s2cResult = mysql_query($s2cQuery);
  unset($serviceCommands);
  for($s2cCount=0; $s2cRow=mysql_fetch_row($s2cResult); $s2cCount++) {
    list($s2cId) = $s2cRow;
    $serviceCommands[] = $s2cId;
  }
}
$configQuery = "SELECT c.contact_name, 
                      c.alias, 
                      c.service_notification_options,
                      c.host_notification_options, 
                      c.email, 
                      c.pager, 
                      c.service_notification_period,
                      c.host_notification_period
              FROM contacts c
              ORDER BY c.contact_name";
              
$configResult = mysql_query($configQuery);

for($configCount=0; $configRow=mysql_fetch_row($configResult); $configCount++) {
  list($contact_name, $alias, $service_notification_options, $host_notification_options, $email, $pager, $service_notification_period, $host_notification_period) = $configRow;
        
  for($serviceCommandsCount=0; $serviceCommandsCount<count($serviceCommands); $serviceCommandsCount++) {
                  $serviceId = $serviceCommands[$serviceCommandsCount];
                  $service_notification_command.=get_value_from_id("misccommands", "command_name", $serviceId);
  
                  if(($serviceCommandsCount) !== (count($serviceCommands)-1) ) {
                          $service_notification_command.=", ";
                  }
  
  }
  unset($serviceCommands);

  for($hostCommandsCount=0; $hostCommandsCount<count($hostCommands); $hostCommandsCount++) {
          $hostId = $hostCommands[$hostCommandsCount];
          $host_notification_command.=get_value_from_id("misccommands", "command_name", $hostId);
  
          if(($hostCommandsCount) !== (count($hostCommands)-1) ) {
              $host_notification_command.=", ";
          }
  
  }
  unset($hostCommands);
  $service_notification_period=get_value_from_id("timeperiods", "timeperiod_name", $service_notification_period);
  $host_notification_period=get_value_from_id("timeperiods", "timeperiod_name", $host_notification_period);

$config.="define contact{
        contact_name                    $contact_name
        alias                           $alias
        service_notification_period     $service_notification_period
        host_notification_period        $host_notification_period
        service_notification_options    $service_notification_options
        host_notification_options       $host_notification_options
        service_notification_commands   $service_notification_command
        host_notification_commands      $host_notification_command
        email                           $email
";
	if( strlen($pager) > 1) {
	$config .="        pager                           $pager
	";
	}
	$config .="
		}
	";
}

fwrite($handle,$config);
fclose($handle);

/* --------------------------------------------------------------
      write the hostgroups.cfg file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."hostgroups.cfg";
$handle = fopen($path,"w");

unset($config);
// $configQuery = "SELECT `hostgroup_name`, `alias`, `contact_groups`, `members` FROM `hostgroups` ORDER BY `hostgroup_name`";
// walk through host groups
$hgSelectQuery = "SELECT id FROM hostgroups ORDER BY hostgroup_name";
$hgSelectResult = mysql_query($hgSelectQuery);

for($hgCount=0; $hgRow=mysql_fetch_row($hgSelectResult); $hgCount++) {
  list($hostGroupsId) = $hgRow;
  
  // get hosts in hostgroup
  $h2hQuery = "SELECT hosts_id FROM hosts2hostgroups WHERE hostgroups_id='$hostGroupsId'";
  $h2hResult = mysql_query($h2hQuery);
  
  unset($members);
  for($h2hCount=0; $h2hRow=mysql_fetch_row($h2hResult); $h2hCount++) {
    list($member) = $h2hRow;
    $members[] = $member;
  }
  
  $configQuery = "SELECT hostgroup_name, alias, contact_groups FROM hostgroups WHERE id='$hostGroupsId'";
  $configResult = mysql_query($configQuery);
  for($configCount=0; $configRow=mysql_fetch_row($configResult); $configCount++) {
          list($hostgroup_name, $alias, $contact_groups) = $configRow;
          $contact_groups = get_value_from_id("contactgroups", "contactgroup_name", $contact_groups);
          // echo $contact_groups."<BR />\n";
  unset($member);

  for($membersCount=0; $membersCount<count($members); $membersCount++) {
          $memberId = $members[$membersCount];
          $member.=get_value_from_id("hosts", "host_name", $memberId);
          if(($membersCount) !== (count($members)-1) ) {
              $member.=",";
          }
  }
  $config.="define hostgroup{
          hostgroup_name  $hostgroup_name
          alias           $alias
          contact_groups  $contact_groups
          members         $member
          }
  ";
  // echo $config."<BR>\n";
  }
}
fwrite($handle,$config);
fclose($handle);

/* --------------------------------------------------------------
      write the hosts.cfg file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."hosts.cfg";
$handle = fopen($path,"w");

unset($config);
$configQuery = "SELECT `name`, `notifications_enabled`, `event_handler_enabled`, `flap_detection_enabled`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `register` FROM `hoststemplate` ORDER BY `name`";
$configResult = mysql_query($configQuery);

for($templateCount=0; $templateRow=mysql_fetch_row($configResult); $templateCount++) {
	list($name, $notifications_enabled, $event_handler_enabled, $flap_detection_enabled, $process_perf_data, $retain_status_information, $retain_nonstatus_information, $register) = $templateRow;
$config.="
define host{
        name					$name
        notifications_enabled			$notifications_enabled
        event_handler_enabled			$event_handler_enabled
        flap_detection_enabled			$flap_detection_enabled
        process_perf_data			$process_perf_data
        retain_status_information		$retain_status_information
        retain_nonstatus_information		$retain_nonstatus_information
        register				0
}
";
}

$configQuery = "SELECT `use`, `host_name`, `parents`, `alias`, `address`, `check_command`, `max_check_attempts`, `notification_interval`, `notification_period`, `notification_options` FROM `hosts` ORDER BY `host_name`";
// echo $configQuery."<BR /> \n";
$configResult = mysql_query($configQuery);


// loop through hosts
for($hostCount=0; $hostRow=mysql_fetch_row($configResult); $hostCount++) {
  list($use, $host_name, $parents, $alias, $address, $check_command, $max_check_attempts, $notification_interval, $notification_period, $notification_options) = $hostRow;
  $use = get_value_from_id("hoststemplate", "name", $use);
  $check_command = get_value_from_id("checkcommands", "command_name", $check_command);
  $notification_period = get_value_from_id("timeperiods", "timeperiod_name", $notification_period);
  
$config.="
define host{
        use                     $use
        host_name               $host_name
";

if( strlen($parents) > 2) {
$config.="        parents                 ".$parents."\n";
}

$config.="        alias                   $alias
        address                 $address
        check_command           $check_command
        max_check_attempts      $max_check_attempts
        notification_interval   $notification_interval
        notification_period     $notification_period
        notification_options    $notification_options
        }
";
unset($parents);
}
fwrite($handle,$config);
fclose($handle);

/* --------------------------------------------------------------
      write the misccommands.cfg file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."misccommands.cfg";
$handle = fopen($path,"w");

unset($config);
$configQuery = "SELECT `command_name`, `command_line` FROM `misccommands` ORDER BY `command_name`";
$configResult = mysql_query($configQuery);

$config.="
################################################################################
# COMMAND DEFINITIONS
#
# SYNTAX:
#
#       define command{
#               template      <templatename>
#               name          <objectname>
#               command_name  <commandname>
#               command_line  <commandline>
#               }
#
# WHERE:
#
# <templatename> = object name of another command definition that should be
#                  used as a template for this definition (optional)
# <objectname>   = object name of command definition, referenced by other
#                  command definitions that use it as a template (optional)
# <commandname>  = name of the command, as recognized/used by Nagios
# <commandline>  = command line
#
################################################################################
";


for($templateCount=0; $templateRow=mysql_fetch_row($configResult); $templateCount++) {
	list($command_name, $command_line) = $templateRow;
$config.="
# '$command_name' command definition
define command{
	command_name	$command_name
	command_line	$command_line
	}
";
}
fwrite($handle,$config);
fclose($handle);

/* --------------------------------------------------------------
      write the timeperiods.cfg file
   -------------------------------------------------------------- */

$path = $nagiosConfigExportPath."timeperiods.cfg";
$handle = fopen($path,"w");

unset($config);
$configQuery = "SELECT `timeperiod_name`, `alias`, `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, `sunday` FROM `timeperiods` ORDER BY `timeperiod_name`";
$configResult = mysql_query($configQuery);

for($timePeriodCount=0; $timePeriodRow=mysql_fetch_row($configResult); $timePeriodCount++) {
	list($timeperiod_name, $alias, $monday, $tuesday, $wednesday, $thursday, $friday, $saturday, $sunday)=$timePeriodRow;
$config.="
# '$timeperiod_name' timeperiod definition
define timeperiod{
        timeperiod_name $timeperiod_name
        alias           $alias
";
if( strlen($sunday) > 1) $config.="        sunday          $sunday \n";
if( strlen($monday) > 1) $config.="        monday          $monday \n";
if( strlen($tuesday) > 1) $config.="        tuesday         $tuesday \n";
if( strlen($wednesday) > 1) $config.="        wednesday       $wednesday \n";
if( strlen($thursday) > 1) $config.="        thursday        $thursday \n";
if( strlen($friday) > 1) $config.="        friday          $friday \n";
if( strlen($saturday) > 1) $config.="        saturday        $saturday \n";
$config.="        }
";
}
// echo "<PRE>$config</PRE>\n";
fwrite($handle,$config);
fclose($handle);
$locationRedirect = $nagiosConfigURLpath."index.php";
header("Location: $locationRedirect");
?>
