#! /usr/bin/perl

############################################################################
# Copyright (C)2007 Guy Van Sanden <nocturn00@gmail.com>
# http://nocturn.vsbnet.be
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
############################################################################

use Getopt::Std;
use Socket;
use Sys::Hostname;
use LWP;
use DBI;
use Switch;
    
%options=();
getopts("o:hvp:VH:D:U:P:",\%options);

if(defined($options{d})){
	$DEBUG="Y";
} else {
	$DEBUG="N";
}

if(defined($options{v})){ &init; &printversion; exit 0; }
if(defined($options{h})){ &init; &printversion; &help; exit 0; }
if(defined($options{V})){ &init; &printnumericversion; ; exit 0}
############################################################################
# Main program
############################################################################

&init;
&checks;
&xmlsensor;

############################################################################
# END Main program
############################################################################

############################################################################
# Functions
############################################################################
sub init {
	$author="Guy Van Sanden";
	$version="0.4";
	$program="xmlsensor_phpbb_version";
	$sensor="phpbb_version";
	$program_description="An XMLSensor to check if you are running the latest PHPBB forum software, it supports version 2 and 3";
	$copyyear="2007";
	@capabilities = ("xmlsensor1.1");
	$url="http://nocturn.vsbnet.be";
	$email="nocturn00\@gmail.com";
	$time=time();
	$hostname=hostname();
}

# Pre-flight checks.
sub checks {
	if(!defined($options{o})){
		print "ERROR: Output file not specified, exiting.\n";
		exit 2;
	}	
}


# THE ACTUAL CHECKING CODE
sub xmlsensor {
	my $majorversion;
	# Moved checking code into functions to support both phpbb 2 and 3
	if(!defined($options{p})) {
		$majorversion = 2;
	} else {
		$majorversion = $options{p};
	}

	switch ($majorversion) {
		case 1          { &exit_unknown("PHPBB1 is not supported") } 
		case 2          { &phpbb2 }
		case 3		{ &exit_unknown("PHPBB3 is not implemented yet") }
		else		{ &exit_unknown("Unknown PHPBB version $majorversion") }
        }
	
		

}

# PHPBB version 2 checking code
sub phpbb2 {
        # SQL: SELECT config_value FROM `parentingforum`.`phpbb_config` WHERE `config_name` LIKE '%version%'
        my $phpbbversion;

        my $dsn = "DBI:mysql:database=$options{D}:host=$options{H}";
        my $db_user_name = "$options{U}";
        my $db_password = "$options{P}";
        my ($id, $password);
        my $dbh = DBI->connect($dsn, $db_user_name, $db_password);

        my $sth = $dbh->prepare(qq{
                SELECT config_value FROM phpbb_config WHERE config_name LIKE '%version%'
        });
        $sth->execute();

        $phpbbversion = "2" . $sth->fetchrow_array();
        $sth->fetchrow_array();

        # Now we get the current version from phpbb.coma
        my $url = "http://www.phpbb.com/updatecheck/20x.txt";
        my $browser = LWP::UserAgent->new;
        my $response = $browser->get( $url );
        if(!$response->is_success) {
                &exit_unknown("Can't get current phpbb version from phpbb.com");
        }

        # Result has been loaded into $response->content
        my $currentphpbbversion = $response->content;
        chomp($currentphpbbversion);
        $currentphpbbversion =~ s/\n/./g;

        # OK,we have both versions, let's compare them.
        if($phpbbversion eq $currentphpbbversion) {
                 &xmlout("OK","PHPBB2 is up to date ($phpbbversion/$currentphpbbversion)");
        } else {
                &xmlout("WARNING","PHPBB2 needs to be updated from $phpbbversion to $currentphpbbversion");
        }
}

# Exit with unknown status
sub exit_unknown {
	my $message = $_[0];
	&xmlout("UNKNOWN","$message");
	exit 0;
}

# xmlout(status,message);
sub xmlout {
	#<XMLSensor schema="xmlsensor1.0">
	#        <Sensor>
	#             <SensorName>[Text]</SensorName>
	#             <Status>UNKNOWN|OK|WARNING|CRITICAL</Status>
	#             <Message>[Text]</Message>
	#             <MachineName>[Text]</MachineName>
	#             <TimeStamp>[Unix Epoch]</TimeStamp>
	#        </Sensor>
	#</XMLSensor>
	
	my $xmlstatus = $_[0];
	my $xmlmessage = $_[1];

	open(XMLOUT,">$options{o}") || die "ERROR: Could not open output file $options{o} for writing.\n";

	print XMLOUT "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
	print XMLOUT "<XMLSensor schema=\"xmlsensor1.1\">\n";
	print XMLOUT "\t<Sensor>\n";
	print XMLOUT "\t\t<SensorName>$sensor</SensorName>\n";
	print XMLOUT "\t\t<Status>$xmlstatus</Status>\n";
	print XMLOUT "\t\t<Message>$xmlmessage</Message>\n";
	print XMLOUT "\t\t<MachineName>$hostname</MachineName>\n";
	print XMLOUT "\t\t<TimeStamp>$time</TimeStamp>\n";
	print XMLOUT "\t\t<Program>$program</Program>\n";
	print XMLOUT "\t\t<Version>$version</Version>\n";
	print XMLOUT "\t</Sensor>\n";
	print XMLOUT "</XMLSensor>\n";

	close(XMLOUT);
}

#
sub output {
        my $text = $_[0];
	if($DEBUG eq "Y") {
				print STDERR "-- ";
                print STDERR "$text";
				print STDERR" --\n";
        }

}

# Print version information
sub printversion {
	print "$program version $version\n";
	print "Copyright (C)$copyyear $author, Licensed under the GPL v3 or later.\n";
	print "$program_description\n";

	print "\n";
        # Print version and exit
        print "Capabilities: [ ";
        foreach(@capabilities){
                print "$_ ";
        }
        print "]\n";

        print "\n";
}

# Print numeric version (for wrapper programs)
sub printnumericversion {
	print "$version";
}

# Help 
sub help {
	print "USAGE: \n$program -o <outputfile> -H <mysql hostname> -D <mysql database>\n";
	print "\n";

	print "\t-o\tOutput file\n";
	print "\t-v\tPrint version and exit\n";
	print "\t-h\tPrint this help\n";
	print "\t-p\tPHPBB version to check (2 or 3, defaults to 2)\n";
	print "\t-H\tHostname of the MySQL database\n";
	print "\t-D\tDatabase to connect to\n";
	print "\t-U\tUsername for the database connection\n";
	print "\t-P\tPassword for the database connection\n";

	print "\n";
}

