#! /usr/bin/perl

############################################################################
# Copyright (C)2007 Guy Van Sanden <nocturn00@gmail.com>
# http://nocturn.vsbnet.be
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
############################################################################

use Getopt::Std;
use Socket;
use Sys::Hostname;
use LWP;
use DBI;
    
%options=();
getopts("o:hvVH:i:",\%options);

if(defined($options{d})){
	$DEBUG="Y";
} else {
	$DEBUG="N";
}

if(defined($options{v})){ &init; &printversion; exit 0; }
if(defined($options{h})){ &init; &printversion; &help; exit 0; }
if(defined($options{V})){ &init; &printnumericversion; ; exit 0}
############################################################################
# Main program
############################################################################

&init;
&checks;
&xmlsensor;

############################################################################
# END Main program
############################################################################

############################################################################
# Functions
############################################################################
sub init {
	$author="Guy Van Sanden";
	$version="0.2";
	$program="xmlsensor_smf_version";
	$sensor="smf_version";
	$program_description="An XMLSensor to check if you are running the latest Simple Machines forum software";
	$copyyear="2007";
	@capabilities = ("xmlsensor1.1");
	$url="http://nocturn.vsbnet.be";
	$email="nocturn00\@gmail.com";
	$time=time();
	$hostname=hostname();
}

# Pre-flight checks.
sub checks {
	if(!defined($options{i})){
	        print "ERROR: Index.php file not specified, exiting.\n";
		exit 2;
	}

	if(!defined($options{o})){
		print "ERROR: Output file not specified, exiting.\n";
		exit 2;
	}	
}


# THE ACTUAL CHECKING CODE
sub xmlsensor {
	# Get the version string from the index.php file, given in the -i option
	# $forum_version = 'SMF 1.1.2';
	my $smfversion = "--";

	open(INDEX,"$options{i}");

	while(<INDEX>){
		chomp();
		if(/^\$forum_version = \'SMF (.+)\'/) {
			$smfversion = $1;
		}
	}

	close(INDEX);

	# Let's get the current SMF version online
        # window.smfVersion = "SMF 1.1.3";
        my $url = "http://www.simplemachines.org/xml/current-version.js";
        my $browser = LWP::UserAgent->new;
        my $response = $browser->get( $url );
        if(!$response->is_success) {
                &exit_unknown("Can't get current SMF version");
        }

        # Result has been loaded into $response->content
        my $currentsmfversion = $response->content;
        chomp($currentsmfversion);
        $currentsmfversion =~ /window.smfVersion = \"SMF (.+)\"/;
	$currentsmfversion = $1;

	# OK,we have both versions, let's compare them.
	if($smfversion eq $currentsmfversion) {
		 &xmlout("OK","SMF is up to date ($smfversion/$currentsmfversion)");
	} else {
		&xmlout("WARNING","SMF needs to be updated from $smfversion to $currentsmfversion");
	}

}

# Exit with unknown status
sub exit_unknown {
	my $message = $_[0];
	&xmlout("UNKNOWN","$message");
	exit 0;
}

# xmlout(status,message);
sub xmlout {
	#<XMLSensor schema="xmlsensor1.0">
	#        <Sensor>
	#             <SensorName>[Text]</SensorName>
	#             <Status>UNKNOWN|OK|WARNING|CRITICAL</Status>
	#             <Message>[Text]</Message>
	#             <MachineName>[Text]</MachineName>
	#             <TimeStamp>[Unix Epoch]</TimeStamp>
	#        </Sensor>
	#</XMLSensor>
	
	my $xmlstatus = $_[0];
	my $xmlmessage = $_[1];

	open(XMLOUT,">$options{o}") || die "ERROR: Could not open output file $options{o} for writing.\n";

	print XMLOUT "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
	print XMLOUT "<XMLSensor schema=\"xmlsensor1.1\">\n";
	print XMLOUT "\t<Sensor>\n";
	print XMLOUT "\t\t<SensorName>$sensor</SensorName>\n";
	print XMLOUT "\t\t<Status>$xmlstatus</Status>\n";
	print XMLOUT "\t\t<Message>$xmlmessage</Message>\n";
	print XMLOUT "\t\t<MachineName>$hostname</MachineName>\n";
	print XMLOUT "\t\t<TimeStamp>$time</TimeStamp>\n";
	print XMLOUT "\t\t<Program>$program</Program>\n";
	print XMLOUT "\t\t<Version>$version</Version>\n";
	print XMLOUT "\t</Sensor>\n";
	print XMLOUT "</XMLSensor>\n";

	close(XMLOUT);
}

#
sub output {
        my $text = $_[0];
	if($DEBUG eq "Y") {
				print STDERR "-- ";
                print STDERR "$text";
				print STDERR" --\n";
        }

}

# Print version information
sub printversion {
	print "$program version $version\n";
	print "Copyright (C)$copyyear $author, Licensed under the GPL v3 or later.\n";
	print "$program_description\n";

	print "\n";
        # Print version and exit
        print "Capabilities: [ ";
        foreach(@capabilities){
                print "$_ ";
        }
        print "]\n";

        print "\n";
}

# Print numeric version (for wrapper programs)
sub printnumericversion {
	print "$version";
}

# Help 
sub help {
	print "USAGE: \n$program -o <outputfile> -i <index.php file>\n";
	print "\n";

	print "\t-o\tOutput file\n";
	print "\t-v\tPrint version and exit\n";
	print "\t-h\tPrint this help\n";
	print "\t-i\tIndex.php file 'including path)\n";

	print "\n";
}

