#!/sbin/sh

#
# bbnt2ns: SysV startup script for the bbnt2ns.pl daemon for netsaint.
#

bbnt2ns="/usr/local/netsaint/bin/bbnt2ns.pl"
uid="netsaint"

case "$1" in

'start')
	if [ -x $bbnt2ns ]; then
		su $uid -c $bbnt2ns
	fi
	;;

'status')
	ps -ef | grep bbnt2ns.pl | grep -v grep
	;;

'stop')
	ps -ef | grep bbnt2ns.pl | grep -v grep | awk '{print $2}' | xargs kill -9
	;;

*)
	echo "Usage: $0 { start | stop | status }"
	exit 1
	;;

esac
exit 0
