#!/bin/sh

PATH_LOG_FETCHMAIL="/var/log/ctk/mail/fetchmail"
TMP_FILE="/tmp/fetchmail_error"
path_before=$PWD

rm $TMP_FILE
code=3
if [ ! -d $PATH_LOG_FETCHMAIL ]; then
  msg="Fichier $LOG_FETCHMAIL inexistant"
  return
fi
cd $PATH_LOG_FETCHMAIL
tail -q -n 20 *.log | grep "fetchmail" > $TMP_FILE.1 
cat $TMP_FILE.1 | grep -v "mise en sommeil" | grep -v "rveill " | grep -v " messages pour " | grep -v "1 message pour " | grep -v "dmarrage de fetchmail " | grep -v "lecture du message " | grep -v "termin par un signal 15" | grep -v "procmail" | grep -v "fetchmail:  limin" | grep -v "user waited" | grep -v "skipping message" > $TMP_FILE

nbErrorLog=`cat /tmp/fetchmail_error | wc -l`
nbErrorTooOld=`find . -name "*.log" -mmin +150 | wc -l`

code=0
if [ $nbErrorLog -ge $CRITICAL ]; then
   code=2
else if 
  [ $nbErrorLog -ge $WARNING ]; then
   code=1 
fi
fi

if [ $nbErrorTooOld -ge 1 ]; then
   code=1
fi

msg=`tail -n 1 $TMP_FILE`
msg="$nbErrorLog erreurs, $nbErrorTooOld trop ancien, $msg"
#rm $TMP_FILE
cd $path_before

