#!/bin/sh
# Envoie l'tat au serveur Nagios pour un seul service
version=0.1

. ../etc/nagwen.cfg
. ../etc/nagwen_service.cfg
. ../lib/nagwen_lib
. ../lib/nagwen_suivi

CONFIG=$PREFIX/etc/send_nsca.cfg
SEND=$PREFIX/sbin/send_nsca
SERVICE=$1
REP_ORI=$PWD
usage()
{
    cat <<EOF
    Usage: nagwen_send SERVICE [OPTION]

    Known values for OPTION are:

     --sleep=x          attendre x sec avant de lancer le test
     --help             display this help and exit
     --version          output version information

EOF

     exit $1
 }

if test $# -eq 0; then
     usage 1
fi
shift
		      
while test $# -gt 0; do
    case "$1" in
       -*=*) optarg=`echo "$1" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
          *) optarg= ;;
     esac

     case "$1" in
       --sleep=*)
         SLEEP=$optarg
         ;;

       --debug)
         DEBUG=1
         ;;
	 
       --version)
         echo $version
         exit 0
         ;;

       --help)
          usage 0
          ;;

       *)
         usage 1
	 ;;

     esac
     shift
done



if [  ! "$SERVICE" ]; then
	echo "Erreur : service non dfini !";
	echo "Erreur : service non dfini !" >> $NAGWEN_LOG
	return
fi

nagwen_log "SERVICE : $SERVICE"

if [ "$SLEEP" ]; then
   echo "Sleep de $SLEEP secondes !"	
   sleep $SLEEP
fi

# Initalisation de variables
  code=3
  msg="????"
  unset file_info_sup
  
  nagwen_get_variable "WARNING"
  WARNING=$?
  nagwen_get_variable "CRITICAL"
  CRITICAL=$?
  nagwen_get_variable "NB_RETRY"
  NB_RETRY=$?

  service_lower=`echo $SERVICE | tr A-Z a-z`
  script="$PREFIX/bin/nagwen_$service_lower.sh"

  # Debug
  if [ "$DEBUG" == "1" ]; then
	  echo "" 
	  echo "*****************" 
	  echo "SERVICE $SERVICE"
	  echo "NbRetry=$NB_RETRY"
	  echo "Warning=$WARNING"
	  echo "Critical=$CRITICAL"
	  echo "Script $script"
  fi

  # Lancement du script
  . $script

  # MAJ du suivi
  nagwen_suivi_refresh
  # Test code
  nagwen_suivi_test

  # Envoi des infos au serveur Nagios
  ALERT="$NAGIOS_HOST	$SERVICE	$nagwen_code	$msg"
  if [ "$DEBUG" == "1" ]; then
      echo $ALERT	  
      echo "$SEND  -H $NAGIOS_SERVEUR -c $CONFIG"
      echo "**"
  fi
  
  echo "C=$code/NC=$nagwen_code"

  # Doit-on vraiment envoyer au serveur Nagios ?
  if [[ "$noSendNagios" != "1" || "$code" != "0" ]]; then
      nagwen_log "$ALERT"
      echo "$ALERT" | $SEND -H $NAGIOS_SERVEUR -c $CONFIG

      # Si fichier spcifi, on l'envoie par mail
  #    if [[ "$file_info_sup" && $nagwen_code -ge 0 && "$nb_suivi" == "$NB_RETRY" ]]; then
  #        envoi_mail_file
#      fi

  
      # Si erreur, on re-emet une 2eme fois un rapport sur ce service
      if [ ! "$SLEEP" ]; then
         if [ "$nagwen_code" -ge 1 ]; then
             NEXT_TEST=120
      #      ./nagwen_send.sh $SERVICE --sleep=$NEXT_TEST & 
         fi
      fi
  fi 

  cd $REP_ORI
