%define prefix /usr

Summary:    SNMP proxy daemon designed for use with nagios
Name:       snmppd
Version:    0.5.2
Release:    1
Packager:   Vladislav Bogdanov <slava@nsys.by>
Source:     %{name}-%{version}.tar.gz
License:    GPL
Group:      Networking/Daemons
Prefix:     %{prefix}
Buildroot:  %{_tmppath}/%{name}-%{version}-root
Requires:   libsplit

%description
snmppd is SNMP proxy daemon.
It loads MIBs upon startup, listens on TCP socket for SNMP GET requests,
polls specified host and returns value to caller process.

%package nagios
Summary:    snmpp plugin for nagios
Group:      Networking/Utilities
Requires:   nagios

%description nagios
check_snmpp plugin for nagios (replacement for check_snmp)

%prep
%setup -q

%build
%configure --enable-more-warnings --sysconfdir=/etc/snmppd --libexecdir=%{prefix}/lib/nagios/plugins
make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/init.d
install  snmppd.init $RPM_BUILD_ROOT/etc/init.d/snmppd
mkdir -p $RPM_BUILD_ROOT/var/run/snmppd

%clean
rm -rf $RPM_BUILD_ROOT

%pre
/usr/bin/id -u snmppd >/dev/null 2>&1
if [ $? -ne 0 ] ; then
    /usr/sbin/useradd -r -u 138 -M -o -g daemon -d /var/run/snmppd -c "SNMP proxy daemon" -s /sbin/nologin snmppd
fi

%post
/sbin/chkconfig --add snmppd
if [ "$1" != "0" ] ; then
    /sbin/service snmppd condrestart >/dev/null 2>&1 || true
fi

%preun
if [ "$1" = "0" ] ; then
    /sbin/service snmppd stop >/dev/null 2>&1 || true
    /sbin/chkconfig --del snmppd
fi


%files
%defattr(-,root,root)
%doc COPYING FAQ README ChangeLog AUTHORS TODO
%config(noreplace) /etc/snmppd/snmppd.conf
/etc/init.d/snmppd
%{prefix}/sbin/snmppd
%attr(0700,snmppd,daemon) /var/run/snmppd

%files nagios
%{prefix}/lib/nagios/plugins/check_snmpp

