#if HAVE_CONFIG_H
#  include "config.h"
#endif

#include <pthread.h>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "conf.h"
#include "log.h"

config_t *config = NULL;

static char *Trim(char *p, char *delim)
{
	int len;
	len = strlen(p);
	while ((len > 0) && strchr(delim, p[len - 1])) {
		p[len - 1] = '\0';
		len--;
	}
	while ((*p) && strchr(delim, *p))
		p++;
	return p;
}

int read_conf(char *file, config_t *config)
{
	FILE *fp = NULL;
	char buffer[2048];
	int i = 0;
	char str[2048] = "";

	if (!file)
		return 0;
	if ((fp = fopen(file, "r")) == NULL) {
		log_error("Could not open file for reading '%s'\n", file);
		return 0;
	} else {
		log_debug(DEBUG_CONFIG, "Reading configuration [%s].", file);
		while (fgets(buffer, 2048, fp)) {
			char *end;
			log_debug(DEBUG_CONFIG, "buffer: %s", buffer);
			i++;
			if (!buffer[0])
				continue;
			end = buffer + strlen(buffer) - 1;
			while ((end >= buffer)
				   && (*end == '\r' || *end == '\n' || *end == ' '
					   || *end == '\t')) {
				*end = 0;
				if (end > buffer)
					end--;
			}
			if (!buffer[0])
				continue;
			if (buffer[0] == '#')
				continue;
			if (*end == '\\') {
				*end = 0;
				strcat(str, buffer);
				continue;
			}
			strcat(str, buffer);
			strcpy(buffer, "");
			log_debug(DEBUG_CONFIG, "str: %s", str);
			if (!strncasecmp(str, "StartThreads", 12) && !config->start_threads) {
				sscanf(Trim(str + 12, "= \t\r\n"), "%d", &(config->start_threads));
			} else if (!strncasecmp(str, "MinThreads", 10) && !config->min_threads) {
				sscanf(Trim(str + 10, "= \t\r\n"), "%d", &(config->min_threads));
			} else if (!strncasecmp(str, "MaxThreads", 10) && !config->max_threads) {
				sscanf(Trim(str + 10, "= \t\r\n"), "%d", &(config->max_threads));
			} else if (!strncasecmp(str, "MinIdleThreads", 14) && !config->min_idle_threads) {
				sscanf(Trim(str + 14, "= \t\r\n"), "%d", &(config->min_idle_threads));
			} else if (!strncasecmp(str, "MaxIdleThreads", 14) && !config->max_idle_threads) {
				sscanf(Trim(str + 14, "= \t\r\n"), "%d", &(config->max_idle_threads));
			} else if (!strncasecmp(str, "User", 4) && !config->user) {
				config->user = strdup(Trim(str + 4, "= \t\r\n"));
			} else if (!strncasecmp(str, "Port", 4) && !config->port) {
				sscanf(Trim(str + 4, "= \t\r\n"), "%d", &(config->port));
			} else if (!strncasecmp(str, "PidFile", 7)) {
				config->pid_file = strdup(Trim(str + 7, "= \t\r\n"));
			} else if (!strncasecmp(str, "LogFile", 7) && !config->log_dest) {
				char *log_file = strdup(Trim(str + 7, "= \t\r\n"));
				if (!strcmp(log_file, "syslog")) {
					config->log_dest = _LOG_SYSLOG;
				} else if (!strcmp(log_file, "stdout")) {
					config->log_dest = _LOG_STDOUT;
				} else if (!strcmp(log_file, "stderr")) {
					config->log_dest = _LOG_STDERR;
				} else {
					config->log_dest = _LOG_FILE;
					config->log_file = log_file;
				}
				if (config->log_dest != _LOG_FILE) {
				    free(log_file);
				}
			} else if (!strncasecmp(str, "SNMPOutputOptions", 17)) {
				config->output_options = strdup(Trim(str + 17, "= \t\r\n"));
			} else if (!strncasecmp(str, "SNMPTimeout", 11)) {
				sscanf(Trim(str + 11, "= \t\r\n"), "%d", &(config->snmp_timeout));
			} else if (!strncasecmp(str, "SNMPRetries", 11)) {
				sscanf(Trim(str + 11, "= \t\r\n"), "%d", &(config->snmp_retries));
			}
			str[0] = 0;
		}
		fclose(fp);
	}
	return 1;
}

void free_conf(config_t **config) {
    if (!config || !(*config))
	return;
    if ((*config)->user) free((*config)->user);
    if ((*config)->output_options) free((*config)->output_options);
    if ((*config)->pid_file) free((*config)->pid_file);
    if ((*config)->log_file) free((*config)->log_file);
    free(*config);
    *config = NULL;
}
