#ifndef _CONF_H_
#define _CONF_H_

#if HAVE_CONFIG_H
#  include "config.h"
#endif


typedef struct config_struct {
	char *user;
	int min_threads;
	int max_threads;
	int min_idle_threads;
	int max_idle_threads;
	int start_threads;
	int port;
	int verbose;
	int debug;
	int nofork;
	int snmp_retries;
	int snmp_timeout;
	char *output_options;
	char *pid_file;
	int log_dest;
	char *log_file;
} config_t;

int read_conf(char *file, config_t *config);
void free_conf(config_t **config);

extern config_t *config;

#endif
