#ifndef _LOG_H_
#define _LOG_H_

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#define _LOG_NONE 0
#define _LOG_SYSLOG 1
#define _LOG_STDOUT 2
#define _LOG_STDERR 3
#define _LOG_FILE 4

typedef enum debug_sections {
	DEBUG_CONFIG = 1,
	DEBUG_THREADS = 4,
	DEBUG_TARGETS = 8,
	DEBUG_SNMP = 16,
	DEBUG_FD = 32,
	DEBUG_FLOW = 64,
	DEBUG_ALLOC = 128
} debug_section;

void log_init(char *program);
void log_close(void);
void log_error(char *fmt, ...);
void log_warning(char *fmt, ...);
void log_info(char *fmt, ...);
void log_debug(debug_section, char *fmt, ...);

#endif /* _LOG_H_ */
