#ifndef _SNMPPD_H_
#define _SNMPPD_H_ 1

#if HAVE_CONFIG_H
#  include "config.h"
#endif

/* Defines */
#ifndef FALSE
# define FALSE 0
#endif
#ifndef TRUE
# define TRUE !FALSE
#endif

#include <stdarg.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>

/* Some useful defaults */
#define NUM_CONSUMERS 15
#define MAX_SNMPPD_OID_LEN 1024
#define SNMPPD_PORT 164
#define MAX_REQUEST_LEN 8192


#include "common.h"
#include "control.h"
#include "queue.h"
#include "log.h"
#include "conf.h"

#define PACKAGE "snmppd"
#define VERSION "0.5.2"

#define CONFIG_FILE "/etc/snmppd/snmppd.conf"


/* Typedefs */

typedef struct object_struct {
    char objid[MAX_SNMPPD_OID_LEN];
    struct object_struct *next;
} object_t;

typedef struct target_struct {
    int sock;
    char *hostname;
    int port;
    int request_type;
    int keepalive;
    object_t *objects;
    char *community;
    pthread_t tid;
} target_t;

/* Precasts */
void usage(char *executable);

void *thread_poll(void *);
void free_entry(target_t **entry);


#endif				/* not _SNMPPD_H_ */
