#ifndef THREADS_H
#define THREADS_H

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#include <pthread.h>

#include "control.h"
#include "conf.h"
#include "snmp.h"
#include "snmppd.h"
#include "queue.h"

typedef struct work_queue {
	data_control control;
	queue work;
} work_queue;
/* I added a job number to the work node.  Normally, the work node
   would contain additional data that needed to be processed. */
typedef struct work_node {
	struct my_node *next;
	target_t *entry;
} wnode;
/* the cleanup queue holds stopped threads.  Before a thread
   terminates, it adds itself to this list.  Since the main thread is
   waiting for changes in this list, it will then wake up and clean up
   the newly terminated thread. */
typedef struct cleanup_queue {
	data_control control;
	queue cleanup;
} cleanup_queue;
/* I added a thread number (for debugging/instructional purposes) and
   a thread id to the cleanup node.  The cleanup node gets passed to
   the new thread on startup, and just before the thread stops, it
   attaches the cleanup node to the cleanup queue.  The main thread
   monitors the cleanup queue and is the one that performs the
   necessary cleanup. */
typedef struct cleanup_node {
	struct my_node *next;
	int threadnum;
	pthread_t tid;
} cnode;

extern work_queue wq;
extern cleanup_queue cq;

void join_all_threads(void);
int create_threads(config_t *config, unsigned int num_threads_to_add);
int del_threads(config_t *config, unsigned int num_threads_to_del);
void initialize_structs(void);
void cleanup_structs(void);
unsigned int get_num_threads(void);
int get_thread_status(unsigned int thread);

#endif
