#if HAVE_CONFIG_H
#  include "config.h"
#endif

#include <pthread.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/types.h>
	     
#include "snmp.h"
#include "common.h"
#include "utils.h"
#include "conf.h"
#include "log.h"

int check_pid(config_t *config) {
    FILE *f;
    char pid_str[32];
    unsigned int pid;

    if ((f = fopen(config->pid_file, "r")) != NULL) {
	/* pid_file already exists */
	if (fgets(pid_str, 30, f) != NULL) {
	    pid = atoi(pid_str);
	    if (pid != 0) {
		fclose(f);
		if ((kill(pid, 0) != 0) && (errno == ESRCH)) {
		    /* stale pid_file */
		    log_info("Stale pid file %s from process %u",
			     config->pid_file, pid);
		    unlink(config->pid_file);
		    return 0;
		} else {
		    log_error("SNMPPD instance is already running (pid %u)",
			      pid);
		    return 1;
		}
	    }
	}
	fclose(f);
	unlink(config->pid_file);
    }
    return 0;
}

int write_pid(config_t *config)
{
    FILE *f;
    mode_t prev_mask;

    prev_mask = umask(022);
    if ((f = fopen(config->pid_file, "w")) != NULL) {
	fprintf(f, "%u\n", getpid());
	fclose(f);
	umask(prev_mask);
	return 0;
    } else {
	log_error("Can't open pid file %s for writing (%s)",
		  config->pid_file, strerror(errno));
	umask(prev_mask);
	return -1;
    }

}
