#!/usr/bin/perl  

# Read text as block
$/ = '';

# Include configuration file
do '/home/reportsock/reportsock.conf';


########## Section one - load, memory and swap ##########
# Get results of the top command (from conf file)
$_ = `$top_cmd`;

# Get load average
m/(\d\.\d\d).*?(\d\.\d\d).*?(\d\.\d\d)/;
my $loadavg1 = $1;
my $loadavg2 = $2;
my $loadavg3 = $3;

# Get CPU idle
m/(\d+\.\d)% idle/;
my $cpuidle = $1;

# Get memory stats
m/Mem:\s+(\d+)[Kk].*?(\d+)[Kk].*?(\d+)[Kk]/;
my $memtotal = $1;
my $memused  = $2;
my $memfree  = $3;

# Get Swap stats
m/Swap:\s+(\d+)[Kk].*?(\d+)[Kk].*?(\d+)[Kk]/;
my $swaptotal = $1;
my $swapused  = $2;
my $swapfree  = $3;

# Open report for writing early, to make things simple.
open(REPORT, ">$rp_loc") or die ("Could not open $rp_loc for writing");

######### Section two - disk usage #########
$df = `$disk_cmd`;
$diskreport = '';
@lines = split (/\n/, $df);
foreach (@lines) {
        if (m/\/dev\/(...\d).*(\d\d\%)/) {
		$partname = $1;
		$partusage = $2;
		print REPORT "Partition: $partname\t Usage: $partusage\n";
	
        	if ($partusage >= $max_hd) { $diskreport .= "$partname BAD $partusage/$max_hd "; }
        		else { $diskreport .= "$partname OK "; }
		chomp $diskreport;
	}
}
									   

########## Section three - report ##########
print REPORT "Load\t$loadavg1, $loadavg2, $loadavg3\n";
print REPORT "CPU\t$cpuidle%\n";
print REPORT "Memory\t$memfree + $memused = $memtotal\n";
print REPORT "Swap\t$swapfree + $swapused = $swaptotal\n";

if ($loadavg1 < $max_load) { print REPORT "Load OK "; }
   else { print REPORT "Load BAD $loadavg1/$max_load "; }
if ($cpuidle > $least_cpuidle) { print REPORT "CPU OK "; }
   else { print REPORT "CPU BAD $cpuidle "; }
if (($swapused/$swaptotal) < $swapallowed) { print REPORT "Swap OK "; }
   else { print REPORT "Swap BAD $swapfree/$swaptotal " . ($swapused/$swaptotal); }

print REPORT $diskreport;

print "\n";
close(REPORT);

my $onelinereport = `tail -1 /tmp/reportsock`;
chomp $onelinereport;
my $reporttime    = `date`;
chomp $reporttime;

open (ONELINEREPORT, ">>/home/greg/reportsock/reportsock/onelinereport.log") or die ("Could not open onelinereport.log for writing");
print ONELINEREPORT "$reporttime: $onelinereport\n";
close ONELINEREPORT;




